/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.CreateDomain;
import org.jclouds.rackspace.clouddns.v1.domain.CreateSubdomain;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;
import org.jclouds.rackspace.clouddns.v1.domain.UpdateDomain;
import org.jclouds.rackspace.clouddns.v1.functions.DomainFunctions;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiLiveTest;
import org.jclouds.rackspace.clouddns.v1.predicates.JobPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DomainApiLiveTest")
public class DomainApiLiveTest
extends BaseCloudDNSApiLiveTest {
    private static final String JCLOUDS_EXAMPLE = System.getProperty("user.name").replace('.', '-') + "-domaintest-jclouds.org";
    private Map<String, Domain> testDomains;

    @Test
    public void testCreateDomainsWithSubdomainsAndRecords() throws Exception {
        Record createMXRecord = Record.builder().type("MX").name(JCLOUDS_EXAMPLE).data("mail." + JCLOUDS_EXAMPLE).priority(Integer.valueOf(11235)).comment("MX Record").ttl(60000).build();
        Record createARecord = Record.builder().type("A").name(JCLOUDS_EXAMPLE).data("10.0.0.1").comment("A Record").ttl(60000).build();
        ImmutableList createRecords = ImmutableList.of((Object)createMXRecord, (Object)createARecord);
        CreateSubdomain createSubdomain1 = CreateSubdomain.builder().name("dev." + JCLOUDS_EXAMPLE).email("jclouds@" + JCLOUDS_EXAMPLE).comment("Hello dev subdomain").build();
        CreateSubdomain createSubdomain2 = CreateSubdomain.builder().name("test." + JCLOUDS_EXAMPLE).email("jclouds@" + JCLOUDS_EXAMPLE).comment("Hello test subdomain").build();
        ImmutableList createSubdomains = ImmutableList.of((Object)createSubdomain1, (Object)createSubdomain2);
        CreateDomain createDomain1 = CreateDomain.builder().name(JCLOUDS_EXAMPLE).email("jclouds1@" + JCLOUDS_EXAMPLE).ttl(Integer.valueOf(600001)).comment("Hello Domain 1").subdomains((Iterable)createSubdomains).records((Iterable)createRecords).build();
        CreateDomain createDomain2 = CreateDomain.builder().name("alt-" + JCLOUDS_EXAMPLE).email("jclouds2@" + JCLOUDS_EXAMPLE).ttl(Integer.valueOf(600002)).comment("Hello Domain 2").build();
        ImmutableList createDomains = ImmutableList.of((Object)createDomain1, (Object)createDomain2);
        this.testDomains = DomainFunctions.toDomainMap((Set)((Set)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().create((Iterable)createDomains))));
        Assert.assertEquals((int)this.testDomains.size(), (int)2);
        Domain jclouds = this.testDomains.get(JCLOUDS_EXAMPLE);
        Domain altjclouds = this.testDomains.get("alt-" + JCLOUDS_EXAMPLE);
        Thread.sleep(1000L);
        Date now = new Date();
        Assert.assertTrue((jclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jclouds.getAccountId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)jclouds.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)jclouds.getEmail(), (String)("jclouds1@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)jclouds.getComment().get()), (String)"Hello Domain 1");
        Assert.assertEquals((int)jclouds.getTTL(), (int)600001);
        Assert.assertTrue((boolean)jclouds.getCreated().before(now));
        Assert.assertTrue((boolean)jclouds.getUpdated().before(now));
        Assert.assertEquals((int)jclouds.getSubdomains().size(), (int)2);
        Subdomain devjclouds = null;
        Subdomain testjclouds = null;
        for (Subdomain subdomain : jclouds.getSubdomains()) {
            if (subdomain.getName().equals("dev." + JCLOUDS_EXAMPLE)) {
                devjclouds = subdomain;
                continue;
            }
            if (!subdomain.getName().equals("test." + JCLOUDS_EXAMPLE)) continue;
            testjclouds = subdomain;
        }
        Assert.assertTrue((devjclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)devjclouds.getName(), (String)("dev." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)devjclouds.getEmail(), (String)("jclouds@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)devjclouds.getComment().get()), (String)"Hello dev subdomain");
        Assert.assertTrue((boolean)devjclouds.getCreated().before(now));
        Assert.assertTrue((boolean)devjclouds.getUpdated().before(now));
        Assert.assertTrue((testjclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)testjclouds.getName(), (String)("test." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)testjclouds.getEmail(), (String)("jclouds@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)testjclouds.getComment().get()), (String)"Hello test subdomain");
        Assert.assertTrue((boolean)testjclouds.getCreated().before(now));
        Assert.assertTrue((boolean)testjclouds.getUpdated().before(now));
        Assert.assertEquals((int)jclouds.getRecords().size(), (int)2);
        RecordDetail mxRecord = null;
        RecordDetail aRecord = null;
        for (RecordDetail record : jclouds.getRecords()) {
            if (record.getType().equals("MX")) {
                mxRecord = record;
                continue;
            }
            if (!record.getType().equals("A")) continue;
            aRecord = record;
        }
        Assert.assertNotNull((Object)mxRecord.getId());
        Assert.assertEquals((String)mxRecord.getType(), (String)"MX");
        Assert.assertEquals((String)mxRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((int)mxRecord.getPriority(), (int)11235);
        Assert.assertEquals((String)mxRecord.getComment(), (String)"MX Record");
        Assert.assertEquals((int)mxRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)mxRecord.getCreated().before(now));
        Assert.assertTrue((boolean)mxRecord.getUpdated().before(now));
        Assert.assertNotNull((Object)aRecord.getId());
        Assert.assertEquals((String)aRecord.getType(), (String)"A");
        Assert.assertEquals((String)aRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertNull((Object)aRecord.getPriority());
        Assert.assertEquals((String)aRecord.getComment(), (String)"A Record");
        Assert.assertEquals((int)aRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)aRecord.getCreated().before(now));
        Assert.assertTrue((boolean)aRecord.getUpdated().before(now));
        Assert.assertTrue((altjclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((altjclouds.getAccountId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)altjclouds.getName(), (String)("alt-" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)altjclouds.getEmail(), (String)("jclouds2@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)altjclouds.getComment().get()), (String)"Hello Domain 2");
        Assert.assertEquals((int)altjclouds.getTTL(), (int)600002);
        Assert.assertTrue((boolean)altjclouds.getCreated().before(now));
        Assert.assertTrue((boolean)altjclouds.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testCreateDomainsWithSubdomainsAndRecords"})
    public void testCreateSimpleDomain() throws Exception {
        CreateDomain createDomain = CreateDomain.builder().name("simple-" + JCLOUDS_EXAMPLE).email("simple-jclouds@" + JCLOUDS_EXAMPLE).build();
        ImmutableList createDomains = ImmutableList.of((Object)createDomain);
        Domain domain = (Domain)((Set)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().create((Iterable)createDomains))).iterator().next();
        Assert.assertEquals((String)domain.getName(), (String)("simple-" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)domain.getEmail(), (String)("simple-jclouds@" + JCLOUDS_EXAMPLE));
        this.testDomains = Maps.newHashMap(this.testDomains);
        this.testDomains.put(domain.getName(), domain);
    }

    @Test(dependsOnMethods={"testCreateSimpleDomain"})
    public void testListDomains() throws Exception {
        ImmutableSet domains = ((CloudDNSApi)this.api).getDomainApi().list().concat().toSet();
        Assert.assertEquals((int)domains.size(), (int)5);
    }

    @Test(dependsOnMethods={"testListDomains"})
    public void testListDomainsWithFilter() throws Exception {
        ImmutableSet domains = ((CloudDNSApi)this.api).getDomainApi().listWithFilterByNamesMatching("alt-" + JCLOUDS_EXAMPLE).concat().toSet();
        Assert.assertEquals((int)domains.size(), (int)1);
    }

    @Test(dependsOnMethods={"testListDomainsWithFilter"})
    public void testListSubdomains() throws Exception {
        Domain domain = this.testDomains.get(JCLOUDS_EXAMPLE);
        ImmutableSet subdomains = ((CloudDNSApi)this.api).getDomainApi().listSubdomains(domain.getId()).concat().toSet();
        Assert.assertEquals((int)subdomains.size(), (int)2);
    }

    @Test(dependsOnMethods={"testListSubdomains"})
    public void testGetDomain() throws Exception {
        Domain domain = this.testDomains.get(JCLOUDS_EXAMPLE);
        Domain jclouds = ((CloudDNSApi)this.api).getDomainApi().get(domain.getId());
        Thread.sleep(1000L);
        Date now = new Date();
        Assert.assertTrue((jclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jclouds.getAccountId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)jclouds.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)jclouds.getEmail(), (String)("jclouds1@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)jclouds.getComment().get()), (String)"Hello Domain 1");
        Assert.assertEquals((int)jclouds.getTTL(), (int)600001);
        Assert.assertTrue((boolean)jclouds.getCreated().before(now));
        Assert.assertTrue((boolean)jclouds.getUpdated().before(now));
        Assert.assertEquals((int)jclouds.getSubdomains().size(), (int)2);
        Subdomain devjclouds = null;
        Subdomain testjclouds = null;
        for (Subdomain subdomain : jclouds.getSubdomains()) {
            if (subdomain.getName().equals("dev." + JCLOUDS_EXAMPLE)) {
                devjclouds = subdomain;
                continue;
            }
            if (!subdomain.getName().equals("test." + JCLOUDS_EXAMPLE)) continue;
            testjclouds = subdomain;
        }
        Assert.assertTrue((devjclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)devjclouds.getName(), (String)("dev." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)devjclouds.getEmail(), (String)("jclouds@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)devjclouds.getComment().get()), (String)"Hello dev subdomain");
        Assert.assertTrue((boolean)devjclouds.getCreated().before(now));
        Assert.assertTrue((boolean)devjclouds.getUpdated().before(now));
        Assert.assertTrue((testjclouds.getId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)testjclouds.getName(), (String)("test." + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)testjclouds.getEmail(), (String)("jclouds@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)testjclouds.getComment().get()), (String)"Hello test subdomain");
        Assert.assertTrue((boolean)testjclouds.getCreated().before(now));
        Assert.assertTrue((boolean)testjclouds.getUpdated().before(now));
        Assert.assertEquals((int)jclouds.getRecords().size(), (int)4);
        RecordDetail mxRecord = null;
        RecordDetail aRecord = null;
        RecordDetail nsRecord = null;
        for (RecordDetail record : jclouds.getRecords()) {
            if (record.getType().equals("MX")) {
                mxRecord = record;
                continue;
            }
            if (record.getType().equals("A")) {
                aRecord = record;
                continue;
            }
            if (!record.getType().equals("NS")) continue;
            nsRecord = record;
        }
        Assert.assertNotNull((Object)mxRecord.getId());
        Assert.assertEquals((String)mxRecord.getType(), (String)"MX");
        Assert.assertEquals((String)mxRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((int)mxRecord.getPriority(), (int)11235);
        Assert.assertEquals((String)mxRecord.getComment(), (String)"MX Record");
        Assert.assertEquals((int)mxRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)mxRecord.getCreated().before(now));
        Assert.assertTrue((boolean)mxRecord.getUpdated().before(now));
        Assert.assertNotNull((Object)aRecord.getId());
        Assert.assertEquals((String)aRecord.getType(), (String)"A");
        Assert.assertEquals((String)aRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertNull((Object)aRecord.getPriority());
        Assert.assertEquals((String)aRecord.getComment(), (String)"A Record");
        Assert.assertEquals((int)aRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)aRecord.getCreated().before(now));
        Assert.assertTrue((boolean)aRecord.getUpdated().before(now));
        Assert.assertNotNull((Object)nsRecord.getId());
        Assert.assertEquals((String)nsRecord.getType(), (String)"NS");
        Assert.assertEquals((String)nsRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((int)nsRecord.getTTL(), (int)600001);
        Assert.assertTrue((boolean)nsRecord.getCreated().before(now));
        Assert.assertTrue((boolean)nsRecord.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testGetDomain"})
    public void testUpdateDomain() throws Exception {
        UpdateDomain updateDomain = UpdateDomain.builder().email("jclouds3@" + JCLOUDS_EXAMPLE).ttl(Integer.valueOf(600003)).comment("Hello Domain Update 3").build();
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().update(this.testDomains.get(JCLOUDS_EXAMPLE).getId(), updateDomain));
        Domain jclouds = ((CloudDNSApi)this.api).getDomainApi().get(this.testDomains.get(JCLOUDS_EXAMPLE).getId());
        Assert.assertEquals((String)jclouds.getEmail(), (String)("jclouds3@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)((String)jclouds.getComment().get()), (String)"Hello Domain Update 3");
        Assert.assertEquals((int)jclouds.getTTL(), (int)600003);
    }

    @Test(dependsOnMethods={"testUpdateDomain"})
    public void testUpdateDomainsTTL() throws Exception {
        ImmutableList ids = ImmutableList.of((Object)this.testDomains.get(JCLOUDS_EXAMPLE).getId(), (Object)this.testDomains.get("alt-" + JCLOUDS_EXAMPLE).getId());
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().updateTTL((Iterable)ids, 1234567));
        Domain jclouds = ((CloudDNSApi)this.api).getDomainApi().get(this.testDomains.get(JCLOUDS_EXAMPLE).getId());
        Domain altjclouds = ((CloudDNSApi)this.api).getDomainApi().get(this.testDomains.get("alt-" + JCLOUDS_EXAMPLE).getId());
        Assert.assertEquals((int)jclouds.getTTL(), (int)1234567);
        Assert.assertEquals((int)altjclouds.getTTL(), (int)1234567);
    }

    @Test(dependsOnMethods={"testUpdateDomainsTTL"})
    public void testUpdateDomainsEmail() throws Exception {
        ImmutableList ids = ImmutableList.of((Object)this.testDomains.get(JCLOUDS_EXAMPLE).getId(), (Object)this.testDomains.get("alt-" + JCLOUDS_EXAMPLE).getId());
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().updateEmail((Iterable)ids, "jclouds-up@" + JCLOUDS_EXAMPLE));
        Domain jclouds = ((CloudDNSApi)this.api).getDomainApi().get(this.testDomains.get(JCLOUDS_EXAMPLE).getId());
        Domain altjclouds = ((CloudDNSApi)this.api).getDomainApi().get(this.testDomains.get("alt-" + JCLOUDS_EXAMPLE).getId());
        Assert.assertEquals((String)jclouds.getEmail(), (String)("jclouds-up@" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)altjclouds.getEmail(), (String)("jclouds-up@" + JCLOUDS_EXAMPLE));
    }

    @Test(dependsOnMethods={"testUpdateDomainsEmail"})
    public void testExportDomain() throws Exception {
        Domain domain = this.testDomains.get(JCLOUDS_EXAMPLE);
        List domainExport = (List)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().exportFormat(domain.getId(), Domain.Format.BIND_9));
        Assert.assertTrue((boolean)((String)domainExport.get(0)).contains(JCLOUDS_EXAMPLE));
    }

    @Test(dependsOnMethods={"testExportDomain"})
    public void testImportDomain() throws Exception {
        ImmutableList contents = ImmutableList.of((Object)("imp-" + JCLOUDS_EXAMPLE + ".      3600  IN SOA   ns.rackspace.com. jclouds.imp-" + JCLOUDS_EXAMPLE + ". 1363882703 3600 3600 3600 3600"), (Object)("imp-" + JCLOUDS_EXAMPLE + ".      600   IN A  50.56.174.152"));
        Domain domain = (Domain)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().importFormat((List)contents, Domain.Format.BIND_9));
        RecordDetail record = (RecordDetail)domain.getRecords().iterator().next();
        Assert.assertEquals((String)domain.getName(), (String)("imp-" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)domain.getEmail(), (String)("jclouds@imp-" + JCLOUDS_EXAMPLE));
        Assert.assertEquals((String)record.getType(), (String)"A");
        Assert.assertEquals((String)record.getData(), (String)"50.56.174.152");
        Assert.assertEquals((int)record.getTTL(), (int)600);
        this.testDomains = Maps.newHashMap(this.testDomains);
        this.testDomains.put(domain.getName(), domain);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        ArrayList domainIds = Lists.newArrayList();
        for (Domain domain : this.testDomains.values()) {
            domainIds.add(domain.getId());
        }
        try {
            JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().delete((Iterable)domainIds, true));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        super.tearDown();
    }
}

