/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.v2_0.domain.Limit;
import org.jclouds.openstack.v2_0.domain.Limits;
import org.jclouds.openstack.v2_0.domain.RateLimit;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.features.LimitApi;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class LimitApiExpectTest
extends BaseCloudDNSApiExpectTest<CloudDNSApi> {
    public void testListLimits() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/limits");
        LimitApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/limit-list.json"))).build())).getLimitApi();
        Limits limits = api.list();
        Assert.assertEquals(limits.getAbsoluteLimits().get("records per domain"), (Object)500);
        Assert.assertEquals(limits.getAbsoluteLimits().get("domains"), (Object)500);
        Assert.assertEquals((int)Iterables.size((Iterable)limits.getRateLimits()), (int)2);
        RateLimit statusRateLimit = (RateLimit)Iterables.tryFind((Iterable)limits.getRateLimits(), LimitApiExpectTest.isStatusRateLimit()).orNull();
        Assert.assertEquals((String)statusRateLimit.getRegex(), (String)".*/v\\d+\\.\\d+/(\\d+/status).*");
        Assert.assertEquals((String)((Limit)Iterables.get((Iterable)statusRateLimit.getLimits(), (int)0)).getVerb(), (String)"GET");
        Assert.assertEquals((int)((Limit)Iterables.get((Iterable)statusRateLimit.getLimits(), (int)0)).getValue(), (int)5);
        Assert.assertEquals((Object)((Limit)Iterables.get((Iterable)statusRateLimit.getLimits(), (int)0)).getRemaining().get(), (Object)5);
        Assert.assertEquals((String)((Limit)Iterables.get((Iterable)statusRateLimit.getLimits(), (int)0)).getUnit(), (String)"SECOND");
    }

    public void testListLimitTypes() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/limits/types");
        LimitApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/limit-types-list.json"))).build())).getLimitApi();
        Iterable limitTypes = api.listTypes();
        Assert.assertEquals((int)Iterables.size((Iterable)limitTypes), (int)3);
    }

    private static Predicate<RateLimit> isStatusRateLimit() {
        return new Predicate<RateLimit>(){

            public boolean apply(RateLimit rateLimit) {
                return rateLimit.getUri().contains("status");
            }
        };
    }
}

