/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.features.RecordApi;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class RecordApiExpectTest
extends BaseCloudDNSApiExpectTest<CloudDNSApi> {
    private static final String JCLOUDS_EXAMPLE = "jclouds-example.com";

    public void testAddRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").payload(this.payloadFromResource("/record-create.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-create-response.json"))).build())).getRecordApiForDomain(3650908);
        Record createMXRecord = Record.builder().type("MX").name(JCLOUDS_EXAMPLE).data("mail.jclouds-example.com").comment("MX Record").priority(Integer.valueOf(11235)).build();
        Record createARecord = Record.builder().type("A").name(JCLOUDS_EXAMPLE).data("10.0.0.1").build();
        ImmutableList createRecords = ImmutableList.of((Object)createMXRecord, (Object)createARecord);
        Job job = api.create((Iterable)createRecords);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
        Assert.assertTrue((boolean)job.getResource().isPresent());
        Set records = (Set)job.getResource().get();
        Date now = new Date();
        RecordDetail mxRecord = null;
        RecordDetail aRecord = null;
        for (RecordDetail record : records) {
            if (record.getType().equals("MX")) {
                mxRecord = record;
                continue;
            }
            if (!record.getType().equals("A")) continue;
            aRecord = record;
        }
        Assert.assertNotNull((Object)mxRecord.getId());
        Assert.assertEquals((String)mxRecord.getType(), (String)"MX");
        Assert.assertEquals((String)mxRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((int)mxRecord.getPriority(), (int)11235);
        Assert.assertEquals((String)mxRecord.getComment(), (String)"MX Record");
        Assert.assertEquals((int)mxRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)mxRecord.getCreated().before(now));
        Assert.assertTrue((boolean)mxRecord.getUpdated().before(now));
        Assert.assertNotNull((Object)aRecord.getId());
        Assert.assertEquals((String)aRecord.getType(), (String)"A");
        Assert.assertEquals((String)aRecord.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertNull((Object)aRecord.getPriority());
        Assert.assertEquals((int)aRecord.getTTL(), (int)60000);
        Assert.assertTrue((boolean)aRecord.getCreated().before(now));
        Assert.assertTrue((boolean)aRecord.getUpdated().before(now));
    }

    public void testListRecords() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list.json"))).build())).getRecordApiForDomain(3650908);
        ImmutableList records = api.list().concat().toList();
        Assert.assertEquals((int)records.size(), (int)4);
        for (RecordDetail record : records) {
            Assert.assertTrue((boolean)record.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testListRecordsPagination() {
        URI endpointPage1 = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records");
        URI endpointPage2 = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records?limit=4&offset=4");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpointPage1).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list-page1.json"))).build(), this.authenticatedGET().endpoint(endpointPage2).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list-page2.json"))).build())).getRecordApiForDomain(3650908);
        ImmutableList records = api.list().concat().toList();
        Assert.assertEquals((int)records.size(), (int)8);
        for (RecordDetail record : records) {
            Assert.assertTrue((boolean)record.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testListByType() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records?type=A");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list-with-filter.json"))).build())).getRecordApiForDomain(3650908);
        ImmutableList records = api.listByType("A").concat().toList();
        Date now = new Date();
        Assert.assertEquals((int)records.size(), (int)1);
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getId(), (String)"A-9846146");
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getType(), (String)"A");
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getData(), (String)"10.0.1.0");
        Assert.assertEquals((int)((RecordDetail)records.get(0)).getTTL(), (int)60000);
        Assert.assertTrue((boolean)((RecordDetail)records.get(0)).getCreated().before(now));
        Assert.assertTrue((boolean)((RecordDetail)records.get(0)).getUpdated().before(now));
    }

    public void testListByTypeAndData() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records?type=A&data=10.0.1.0");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list-with-filter.json"))).build())).getRecordApiForDomain(3650908);
        ImmutableList records = api.listByTypeAndData("A", "10.0.1.0").concat().toList();
        Date now = new Date();
        Assert.assertEquals((int)records.size(), (int)1);
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getId(), (String)"A-9846146");
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getType(), (String)"A");
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getData(), (String)"10.0.1.0");
        Assert.assertEquals((int)((RecordDetail)records.get(0)).getTTL(), (int)60000);
        Assert.assertTrue((boolean)((RecordDetail)records.get(0)).getCreated().before(now));
        Assert.assertTrue((boolean)((RecordDetail)records.get(0)).getUpdated().before(now));
    }

    public void testListByNameAndType() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records?name=jclouds-example.com&type=A");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list-with-filter.json"))).build())).getRecordApiForDomain(3650908);
        ImmutableList records = api.listByNameAndType(JCLOUDS_EXAMPLE, "A").concat().toList();
        Date now = new Date();
        Assert.assertEquals((int)records.size(), (int)1);
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getId(), (String)"A-9846146");
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getType(), (String)"A");
        Assert.assertEquals((String)((RecordDetail)records.get(0)).getData(), (String)"10.0.1.0");
        Assert.assertEquals((int)((RecordDetail)records.get(0)).getTTL(), (int)60000);
        Assert.assertTrue((boolean)((RecordDetail)records.get(0)).getCreated().before(now));
        Assert.assertTrue((boolean)((RecordDetail)records.get(0)).getUpdated().before(now));
    }

    public void testGetByNameAndTypeAndData() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records?name=jclouds-example.com&type=A&data=10.0.1.0");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-list-with-filter.json"))).build())).getRecordApiForDomain(3650908);
        RecordDetail record = api.getByNameAndTypeAndData(JCLOUDS_EXAMPLE, "A", "10.0.1.0");
        Date now = new Date();
        Assert.assertEquals((String)record.getId(), (String)"A-9846146");
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getType(), (String)"A");
        Assert.assertEquals((String)record.getData(), (String)"10.0.1.0");
        Assert.assertEquals((int)record.getTTL(), (int)60000);
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
    }

    public void testGetRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records/A-9846146");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-get.json"))).build())).getRecordApiForDomain(3650908);
        RecordDetail record = api.get("A-9846146");
        Date now = new Date();
        Assert.assertEquals((String)record.getId(), (String)"A-9846146");
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getType(), (String)"A");
        Assert.assertEquals((String)record.getData(), (String)"10.0.1.0");
        Assert.assertEquals((int)record.getTTL(), (int)60000);
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
    }

    public void testUpdateRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records/SRV-21858");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResourceWithContentType("/record-update.json", "application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-update-response.json"))).build())).getRecordApiForDomain(3650908);
        Record record = Record.builder().name("_sip._udp.jclouds-example.com").ttl(86401).data("1 3444 sip.jclouds-example.com").priority(Integer.valueOf(12358)).comment("Updated Protocol to UDP").build();
        Job job = api.update("SRV-21858", record);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testUpdateRecords() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResourceWithContentType("/records-update.json", "application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/records-update-response.json"))).build())).getRecordApiForDomain(3650908);
        Record updateARecord = Record.builder().comment("Multi-record Update").build();
        Record updateMXRecord = Record.builder().comment("Multi-record Update").build();
        ImmutableMap updateRecords = ImmutableMap.of((Object)"A-9846146", (Object)updateARecord, (Object)"MX-9846146", (Object)updateMXRecord);
        Job job = api.update((Map)updateRecords);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testDeleteRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records/A-9846146");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-delete.json"))).build())).getRecordApiForDomain(3650908);
        Job job = api.delete("A-9846146");
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testDeleteRecords() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/domains/3650908/records?id=A-9846146&id=MX-9846146");
        RecordApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/records-delete.json"))).build())).getRecordApiForDomain(3650908);
        ImmutableList recordIds = ImmutableList.of((Object)"A-9846146", (Object)"MX-9846146");
        Job job = api.delete((Iterable)recordIds);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }
}

