/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.features.ReverseDNSApi;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReverseDNSApiExpectTest
extends BaseCloudDNSApiExpectTest<CloudDNSApi> {
    public static final String CLOUD_SERVERS_OPEN_STACK = "cloudServersOpenStack";
    private static final String JCLOUDS_EXAMPLE = "jclouds-example.com";
    private static final URI SERVER_URI = URI.create("https://dfw.servers.api.rackspacecloud.com/v2/123123/servers/f5fb9334-b4f0-49d0-a2cc-57a5772dc7d1");

    public void testCreateReverseDNSRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/rdns");
        ReverseDNSApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").payload(this.payloadFromResource("/record-ptr-create.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-ptr-create-response.json"))).build())).getReverseDNSApiForService(CLOUD_SERVERS_OPEN_STACK);
        Record createPTRRecordIPv4 = Record.builder().type("PTR").name(JCLOUDS_EXAMPLE).data("166.78.146.80").ttl(11235).build();
        Record createPTRRecordIPv6 = Record.builder().type("PTR").name(JCLOUDS_EXAMPLE).data("2001:4800:7812:0514:9a32:3c2a:ff04:aed2").comment("Hello IPv6").build();
        ImmutableList createRecords = ImmutableList.of((Object)createPTRRecordIPv4, (Object)createPTRRecordIPv6);
        Job job = api.create(SERVER_URI, (Iterable)createRecords);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
        Assert.assertTrue((boolean)job.getResource().isPresent());
        Set records = (Set)job.getResource().get();
        Date now = new Date();
        RecordDetail ptrRecordIPv4 = null;
        RecordDetail ptrRecordIPv6 = null;
        for (RecordDetail record : records) {
            if (record.getData().startsWith("166")) {
                ptrRecordIPv4 = record;
                continue;
            }
            if (!record.getData().startsWith("2001")) continue;
            ptrRecordIPv6 = record;
        }
        Assert.assertNotNull((Object)ptrRecordIPv4.getId());
        Assert.assertEquals((String)ptrRecordIPv4.getType(), (String)"PTR");
        Assert.assertEquals((String)ptrRecordIPv4.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)ptrRecordIPv4.getData(), (String)"166.78.146.80");
        Assert.assertEquals((int)ptrRecordIPv4.getTTL(), (int)11235);
        Assert.assertNull((Object)ptrRecordIPv4.getPriority());
        Assert.assertNull((Object)ptrRecordIPv4.getComment());
        Assert.assertTrue((boolean)ptrRecordIPv4.getCreated().before(now));
        Assert.assertTrue((boolean)ptrRecordIPv4.getUpdated().before(now));
        Assert.assertNotNull((Object)ptrRecordIPv6.getId());
        Assert.assertEquals((String)ptrRecordIPv6.getType(), (String)"PTR");
        Assert.assertEquals((String)ptrRecordIPv6.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)ptrRecordIPv6.getData(), (String)"2001:4800:7812:514:9a32:3c2a:ff04:aed2");
        Assert.assertTrue((ptrRecordIPv6.getTTL() > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)ptrRecordIPv6.getPriority());
        Assert.assertEquals((String)ptrRecordIPv6.getComment(), (String)"Hello IPv6");
        Assert.assertTrue((boolean)ptrRecordIPv6.getCreated().before(now));
        Assert.assertTrue((boolean)ptrRecordIPv6.getUpdated().before(now));
    }

    public void testListReverseDNSRecords() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/rdns/cloudServersOpenStack?href=https%3A//dfw.servers.api.rackspacecloud.com/v2/123123/servers/f5fb9334-b4f0-49d0-a2cc-57a5772dc7d1");
        ReverseDNSApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-ptr-list.json"))).build())).getReverseDNSApiForService(CLOUD_SERVERS_OPEN_STACK);
        ImmutableList records = api.list(SERVER_URI).concat().toList();
        Assert.assertEquals((int)records.size(), (int)2);
        for (RecordDetail record : records) {
            Assert.assertTrue((boolean)record.getType().contains("PTR"));
            Assert.assertTrue((boolean)record.getName().contains(JCLOUDS_EXAMPLE));
        }
    }

    public void testGetReverseDNSRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/rdns/cloudServersOpenStack/PTR-557437?href=https%3A//dfw.servers.api.rackspacecloud.com/v2/123123/servers/f5fb9334-b4f0-49d0-a2cc-57a5772dc7d1");
        ReverseDNSApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-ptr-get.json"))).build())).getReverseDNSApiForService(CLOUD_SERVERS_OPEN_STACK);
        RecordDetail record = api.get(SERVER_URI, "PTR-557437");
        Date now = new Date();
        Assert.assertEquals((String)record.getId(), (String)"PTR-557437");
        Assert.assertEquals((String)record.getType(), (String)"PTR");
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getData(), (String)"166.78.146.80");
        Assert.assertEquals((int)record.getTTL(), (int)11235);
        Assert.assertNull((Object)record.getPriority());
        Assert.assertNull((Object)record.getComment());
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
    }

    public void testUpdateReverseDNSRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/rdns");
        ReverseDNSApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResourceWithContentType("/record-ptr-update.json", "application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-ptr-update-response.json"))).build())).getReverseDNSApiForService(CLOUD_SERVERS_OPEN_STACK);
        Record updatePTRRecordIPv4 = Record.builder().type("PTR").name(JCLOUDS_EXAMPLE).data("166.78.146.80").ttl(12358).build();
        ImmutableMap idsToRecords = ImmutableMap.of((Object)"PTR-557437", (Object)updatePTRRecordIPv4);
        Job job = api.update(SERVER_URI, (Map)idsToRecords);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testDeleteReverseDNSRecord() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/rdns/cloudServersOpenStack?href=https%3A//dfw.servers.api.rackspacecloud.com/v2/123123/servers/f5fb9334-b4f0-49d0-a2cc-57a5772dc7d1&ip=166.78.146.80");
        ReverseDNSApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/record-ptr-delete.json"))).build())).getReverseDNSApiForService(CLOUD_SERVERS_OPEN_STACK);
        Job job = api.delete(SERVER_URI, "166.78.146.80");
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }

    public void testDeleteReverseDNSRecords() {
        URI endpoint = URI.create("https://dns.api.rackspacecloud.com/v1.0/123123/rdns/cloudServersOpenStack?href=https%3A//dfw.servers.api.rackspacecloud.com/v2/123123/servers/f5fb9334-b4f0-49d0-a2cc-57a5772dc7d1");
        ReverseDNSApi api = ((CloudDNSApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/records-ptr-delete.json"))).build())).getReverseDNSApiForService(CLOUD_SERVERS_OPEN_STACK);
        Job job = api.deleteAll(SERVER_URI);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.COMPLETED);
    }
}

