/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.NovaAsyncApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.CreateDomain;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.internal.BaseCloudDNSApiLiveTest;
import org.jclouds.rackspace.clouddns.v1.predicates.JobPredicates;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ReverseDNSApiLiveTest")
public class ReverseDNSApiLiveTest
extends BaseCloudDNSApiLiveTest {
    private static final String JCLOUDS_EXAMPLE = System.getProperty("user.name").replace('.', '-') + "-recordtest-jclouds.org";
    private ComputeService computeService;
    private RestContext<NovaApi, NovaAsyncApi> nova;
    private String serverId;
    private URI serverURI;
    private String serverIPv4;
    private String serverIPv6;
    private int domainId;
    private String ptrRecordIPv4Id;
    private String ptrRecordIPv6Id;

    @Test
    public void testCreateServer() throws Exception {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.compute.poll-status.initial-period", "10000");
        overrides.setProperty("jclouds.compute.poll-status.max-period", "10000");
        ComputeServiceContext context = (ComputeServiceContext)ContextBuilder.newBuilder((String)"rackspace-cloudservers-us").credentials(this.identity, this.credential).overrides(overrides).buildView(ComputeServiceContext.class);
        this.computeService = context.getComputeService();
        this.nova = (RestContext)context.unwrap();
        Template template = this.computeService.templateBuilder().smallest().build();
        NodeMetadata nodeMetadata = (NodeMetadata)this.computeService.createNodesInGroup("jclouds-reverse-dns-test", 1, template).iterator().next();
        this.serverId = nodeMetadata.getId();
        this.serverURI = nodeMetadata.getUri();
        ServerApi serverApi = ((NovaApi)this.nova.getApi()).getServerApiForZone(nodeMetadata.getLocation().getParent().getId());
        Server server = serverApi.get(nodeMetadata.getProviderId());
        this.serverIPv4 = server.getAccessIPv4();
        this.serverIPv6 = server.getAccessIPv6();
        System.out.println("serverURI = " + this.serverURI);
        System.out.println("serverIPv4 = " + this.serverIPv4);
        System.out.println("serverIPv6 = " + this.serverIPv6);
    }

    @Test(dependsOnMethods={"testCreateServer"})
    public void testCreateDomain() throws Exception {
        CreateDomain createDomain = CreateDomain.builder().name(JCLOUDS_EXAMPLE).email("jclouds@" + JCLOUDS_EXAMPLE).ttl(Integer.valueOf(60000)).build();
        ImmutableList createDomains = ImmutableList.of((Object)createDomain);
        Domain domain = (Domain)((Set)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().create((Iterable)createDomains))).iterator().next();
        Assert.assertEquals((String)domain.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)domain.getEmail(), (String)("jclouds@" + JCLOUDS_EXAMPLE));
        Assert.assertTrue((boolean)domain.getRecords().isEmpty());
        this.domainId = domain.getId();
    }

    @Test(dependsOnMethods={"testCreateDomain"})
    public void testCreateReverseDNSRecords() throws Exception {
        Record createPTRRecordIPv4 = Record.builder().type("PTR").name(JCLOUDS_EXAMPLE).data(this.serverIPv4).ttl(11235).build();
        Record createPTRRecordIPv6 = Record.builder().type("PTR").name(JCLOUDS_EXAMPLE).data(this.serverIPv6).comment("Hello IPv6").build();
        ImmutableList createRecords = ImmutableList.of((Object)createPTRRecordIPv4, (Object)createPTRRecordIPv6);
        Set records = (Set)JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").create(this.serverURI, (Iterable)createRecords));
        Date now = new Date();
        RecordDetail ptrRecordIPv4 = null;
        RecordDetail ptrRecordIPv6 = null;
        for (RecordDetail record : records) {
            if (record.getData().equals(this.serverIPv4)) {
                ptrRecordIPv4 = record;
                this.ptrRecordIPv4Id = record.getId();
                continue;
            }
            ptrRecordIPv6 = record;
            this.ptrRecordIPv6Id = record.getId();
        }
        Assert.assertNotNull((Object)ptrRecordIPv4.getId());
        Assert.assertEquals((String)ptrRecordIPv4.getType(), (String)"PTR");
        Assert.assertEquals((String)ptrRecordIPv4.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)ptrRecordIPv4.getData(), (String)this.serverIPv4);
        Assert.assertEquals((int)ptrRecordIPv4.getTTL(), (int)11235);
        Assert.assertNull((Object)ptrRecordIPv4.getPriority());
        Assert.assertNull((Object)ptrRecordIPv4.getComment());
        Assert.assertTrue((boolean)ptrRecordIPv4.getCreated().before(now));
        Assert.assertTrue((boolean)ptrRecordIPv4.getUpdated().before(now));
        Assert.assertNotNull((Object)ptrRecordIPv6.getId());
        Assert.assertEquals((String)ptrRecordIPv6.getType(), (String)"PTR");
        Assert.assertEquals((String)ptrRecordIPv6.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertNotNull((Object)ptrRecordIPv6.getData());
        Assert.assertTrue((ptrRecordIPv6.getTTL() > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)ptrRecordIPv6.getPriority());
        Assert.assertEquals((String)ptrRecordIPv6.getComment(), (String)"Hello IPv6");
        Assert.assertTrue((boolean)ptrRecordIPv6.getCreated().before(now));
        Assert.assertTrue((boolean)ptrRecordIPv6.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testCreateReverseDNSRecords"})
    public void testListReverseDNSRecords() throws Exception {
        ImmutableSet records = ((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").list(this.serverURI).concat().toSet();
        Assert.assertEquals((int)records.size(), (int)2);
    }

    @Test(dependsOnMethods={"testListReverseDNSRecords"})
    public void testUpdateAndGetReverseDNSRecords() throws Exception {
        Record updatePTRRecordIPv4 = Record.builder().type("PTR").name(JCLOUDS_EXAMPLE).data(this.serverIPv4).ttl(12358).build();
        ImmutableMap idsToRecords = ImmutableMap.of((Object)this.ptrRecordIPv4Id, (Object)updatePTRRecordIPv4);
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").update(this.serverURI, (Map)idsToRecords));
        RecordDetail record = ((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").get(this.serverURI, this.ptrRecordIPv4Id);
        Date now = new Date();
        Assert.assertNotNull((Object)record.getId());
        Assert.assertEquals((String)record.getType(), (String)"PTR");
        Assert.assertEquals((String)record.getName(), (String)JCLOUDS_EXAMPLE);
        Assert.assertEquals((String)record.getData(), (String)this.serverIPv4);
        Assert.assertEquals((int)record.getTTL(), (int)12358);
        Assert.assertNull((Object)record.getPriority());
        Assert.assertNull((Object)record.getComment());
        Assert.assertTrue((boolean)record.getCreated().before(now));
        Assert.assertTrue((boolean)record.getUpdated().before(now));
    }

    @Test(dependsOnMethods={"testUpdateAndGetReverseDNSRecords"})
    public void testDeleteReverseDNSRecord() throws Exception {
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").delete(this.serverURI, this.serverIPv4));
        Assert.assertNull((Object)((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").get(this.serverURI, this.ptrRecordIPv4Id));
    }

    @Test(dependsOnMethods={"testUpdateAndGetReverseDNSRecords"})
    public void testDeleteReverseDNSRecords() throws Exception {
        JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").deleteAll(this.serverURI));
        Assert.assertNull((Object)((CloudDNSApi)this.api).getReverseDNSApiForService("cloudServersOpenStack").get(this.serverURI, this.ptrRecordIPv6Id));
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        try {
            this.computeService.destroyNode(this.serverId);
            JobPredicates.awaitComplete((CloudDNSApi)((CloudDNSApi)this.api), (Job)((CloudDNSApi)this.api).getDomainApi().delete((Iterable)ImmutableList.of((Object)this.domainId), true));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        super.tearDown();
    }
}

