/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rest.MapBinder;

public class CreateReverseDNSToJSON
implements MapBinder {
    private final Json jsonBinder;

    @Inject
    public CreateReverseDNSToJSON(Json jsonBinder) {
        this.jsonBinder = (Json)Preconditions.checkNotNull((Object)jsonBinder, (Object)"jsonBinder");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)postParams.get("href"), (Object)"href") instanceof URI), (Object)"href is only valid for a URI!");
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)postParams.get("records"), (Object)"records") instanceof Iterable), (Object)"records is only valid for an Iterable!");
        Preconditions.checkNotNull((Object)postParams.get("serviceName"), (Object)"serviceName");
        Iterable records = (Iterable)Iterable.class.cast(postParams.get("records"));
        URI deviceURI = (URI)URI.class.cast(postParams.get("href"));
        String serviceName = postParams.get("serviceName").toString();
        String json = this.toJSON(records, deviceURI, serviceName);
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return (R)((HttpRequest.Builder)request.toBuilder().payload(json)).build();
    }

    private String toJSON(Iterable<Record> records, URI deviceURI, String serviceName) {
        return this.jsonBinder.toJson((Object)ImmutableMap.of((Object)"recordsList", (Object)ImmutableMap.of((Object)"records", records), (Object)"link", (Object)ImmutableMap.of((Object)"href", (Object)deviceURI, (Object)"rel", (Object)serviceName)));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

