/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rest.Binder;

@Singleton
public class UpdateRecordsToJSON
implements Binder {
    private final Json jsonBinder;

    @Inject
    public UpdateRecordsToJSON(Json jsonBinder) {
        this.jsonBinder = (Json)Preconditions.checkNotNull((Object)jsonBinder, (Object)"jsonBinder");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"This binder is only valid for Map<String, Record>");
        Preconditions.checkNotNull(request, (Object)"request");
        Map idsToRecords = (Map)input;
        List<UpdateRecord> updateRecords = UpdateRecordsToJSON.toUpdateRecordList(idsToRecords);
        String json = this.jsonBinder.toJson((Object)ImmutableMap.of((Object)"records", updateRecords));
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }

    static List<UpdateRecord> toUpdateRecordList(Map<String, Record> idsToRecords) {
        ArrayList updateRecords = Lists.newArrayList();
        for (String recordId : idsToRecords.keySet()) {
            Record record = idsToRecords.get(recordId);
            UpdateRecord updateRecord = new UpdateRecord();
            updateRecord.id = recordId;
            updateRecord.name = record.getName();
            updateRecord.ttl = record.getTTL().isPresent() ? (Integer)record.getTTL().get() : null;
            updateRecord.data = record.getData();
            updateRecord.priority = record.getPriority();
            updateRecord.comment = record.getComment();
            updateRecords.add(updateRecord);
        }
        return updateRecords;
    }

    static final class UpdateRecord {
        public String id;
        public String name;
        public Integer ttl;
        public String data;
        public Integer priority;
        public String comment;

        UpdateRecord() {
        }
    }
}

