/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.config;

import com.google.inject.Provides;
import java.util.Date;
import javax.inject.Singleton;
import org.jclouds.aws.config.AWSHttpApiModule;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.RequestSigner;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.filters.RestAuthentication;
import org.jclouds.route53.handlers.Route53ErrorHandler;

@ConfiguresHttpApi
public class Route53HttpApiModule
extends AWSHttpApiModule<Route53Api> {
    @Provides
    @TimeStamp
    protected String provideTimeStamp(DateService dateService) {
        return dateService.rfc1123DateFormat(new Date(System.currentTimeMillis()));
    }

    @Provides
    @Singleton
    RequestSigner provideRequestSigner(RestAuthentication in) {
        return in;
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(Route53ErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(Route53ErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(Route53ErrorHandler.class);
    }
}

