/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.filters;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;
import org.jclouds.rest.RequestSigner;
import org.jclouds.util.Strings2;

@Singleton
public class RestAuthentication
implements HttpRequestFilter,
RequestSigner {
    private final Supplier<Credentials> creds;
    private final javax.inject.Provider<String> timeStampProvider;
    private final Crypto crypto;

    @Inject
    public RestAuthentication(@Provider Supplier<Credentials> creds, @TimeStamp javax.inject.Provider<String> timeStampProvider, Crypto crypto) {
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials current = (Credentials)this.creds.get();
        if (current instanceof SessionCredentials) {
            request = this.replaceSecurityTokenHeader(request, (SessionCredentials)SessionCredentials.class.cast(current));
        }
        request = this.replaceDateHeader(request, (String)this.timeStampProvider.get());
        String signature = this.sign(this.createStringToSign(request));
        return this.replaceAuthorizationHeader(request, signature);
    }

    private HttpRequest replaceSecurityTokenHeader(HttpRequest request, SessionCredentials current) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-amz-security-token", new String[]{current.getSessionToken()})).build();
    }

    private HttpRequest replaceDateHeader(HttpRequest request, String timestamp) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Date", new String[]{timestamp})).build();
        return request;
    }

    public String createStringToSign(HttpRequest input) {
        return input.getFirstHeaderOrNull("Date");
    }

    public String sign(String toSign) {
        try {
            ByteProcessor hmacSHA256 = Macs.asByteProcessor((Mac)this.crypto.hmacSHA256(((Credentials)this.creds.get()).credential.getBytes(Charsets.UTF_8)));
            return BaseEncoding.base64().encode((byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)toSign), (ByteProcessor)hmacSHA256));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("X-Amzn-Authorization", new String[]{"AWS3-HTTPS AWSAccessKeyId=" + ((Credentials)this.creds.get()).identity + ",Algorithm=HmacSHA256,Signature=" + signature})).build();
        return request;
    }
}

