/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import org.easymock.EasyMock;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.s3.S3;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.internal.ListBucketResponseImpl;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.xml.ListBucketHandlerTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class S3Test {
    @Test
    public void testSinglePageResult() throws Exception {
        S3Client api = (S3Client)EasyMock.createMock(S3Client.class);
        ListBucketOptions options = new ListBucketOptions();
        ListBucketResponse response = new ListBucketHandlerTest().expected();
        EasyMock.expect((Object)api.listBucket("bucket", new ListBucketOptions[]{options})).andReturn((Object)response).once();
        EasyMock.replay((Object[])new Object[]{api});
        PagedIterable result = S3.listBucket((S3Client)api, (String)"bucket", (ListBucketOptions)options);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((int)((IterableWithMarker)result.get(0)).size(), (int)10);
    }

    @Test
    public void testMultiPageResult() throws Exception {
        String nextMarker = "FOO";
        S3Client api = (S3Client)EasyMock.createMock(S3Client.class);
        ListBucketOptions options = new ListBucketOptions();
        ListBucketResponse response2 = new ListBucketHandlerTest().expected();
        ListBucketResponseImpl response1 = new ListBucketResponseImpl(response2.getName(), (Iterable)response2, response2.getPrefix(), null, nextMarker, response2.getMaxKeys(), response2.getDelimiter(), false, response2.getCommonPrefixes());
        EasyMock.expect((Object)api.listBucket("bucket", new ListBucketOptions[]{options})).andReturn((Object)response1).once();
        EasyMock.expect((Object)api.listBucket("bucket", new ListBucketOptions[]{options.afterMarker(nextMarker)})).andReturn((Object)response2).once();
        EasyMock.replay((Object[])new Object[]{api});
        PagedIterable result = S3.listBucket((S3Client)api, (String)"bucket", (ListBucketOptions)options);
        Assert.assertEquals((int)result.concat().size(), (int)20);
    }
}

