/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.Set;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.s3.blobstore.functions.BucketToResourceMetadata;
import org.jclouds.s3.blobstore.functions.BucketsToStorageMetadata;
import org.jclouds.s3.domain.BucketMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BucketsToStorageMetadataTest")
public class BucketsToStorageMetadataTest {
    protected Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("aws-ec2").description("aws-ec2").build();
    protected Location region = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").parent(this.provider).build();

    public void test() {
        BucketsToStorageMetadata fn = new BucketsToStorageMetadata(MoreExecutors.sameThreadExecutor(), new BucketToResourceMetadata(Functions.forMap((Map)ImmutableMap.of((Object)"mycontainer", (Object)this.region))));
        MutableStorageMetadataImpl expected = new MutableStorageMetadataImpl();
        expected.setName("mycontainer");
        expected.setType((Enum)StorageType.CONTAINER);
        expected.setLocation(this.region);
        Assert.assertEquals((String)fn.apply((Set)ImmutableSet.of((Object)new BucketMetadata("mycontainer", null, null))).toString(), (String)new PageSetImpl((Iterable)ImmutableSet.of((Object)expected), null).toString());
    }
}

