/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AssignCorrectHostnameForBucketTest")
public class AssignCorrectHostnameForBucketTest {
    public void testWhenNoBucketRegionMappingInCache() {
        AssignCorrectHostnameForBucket fn = new AssignCorrectHostnameForBucket(new RegionToEndpointOrProviderIfNull("aws-s3", Suppliers.ofInstance((Object)URI.create("https://s3.amazonaws.com")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"us-standard", (Object)Suppliers.ofInstance((Object)URI.create("https://s3.amazonaws.com")), (Object)"us-west-1", (Object)Suppliers.ofInstance((Object)URI.create("https://s3-us-west-1.amazonaws.com"))))), Functions.forMap((Map)ImmutableMap.of((Object)"bucket", (Object)Optional.absent())));
        Assert.assertEquals((Object)fn.apply((Object)"bucket"), (Object)URI.create("https://s3.amazonaws.com"));
    }

    public void testWhenBucketRegionMappingInCache() {
        AssignCorrectHostnameForBucket fn = new AssignCorrectHostnameForBucket(new RegionToEndpointOrProviderIfNull("aws-s3", Suppliers.ofInstance((Object)URI.create("https://s3.amazonaws.com")), Suppliers.ofInstance((Object)ImmutableMap.of((Object)"us-standard", (Object)Suppliers.ofInstance((Object)URI.create("https://s3.amazonaws.com")), (Object)"us-west-1", (Object)Suppliers.ofInstance((Object)URI.create("https://s3-us-west-1.amazonaws.com"))))), Functions.forMap((Map)ImmutableMap.of((Object)"bucket", (Object)Optional.of((Object)"us-west-1"))));
        Assert.assertEquals((Object)fn.apply((Object)"bucket"), (Object)URI.create("https://s3-us-west-1.amazonaws.com"));
    }
}

