/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.services;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.rest.RestContext;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"})
public class BucketsLiveTest
extends BaseBlobStoreIntegrationTest {
    public BucketsLiveTest() {
        this.provider = "s3";
        BaseBlobStoreIntegrationTest.SANITY_CHECK_RETURNED_BUCKET_NAME = true;
    }

    public S3Client getApi() {
        return (S3Client)((RestContext)((BlobStoreContext)this.view).unwrap(S3ApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    @Test(groups={"integration", "live"})
    public void deleteBucketIfEmptyNotFound() throws Exception {
        assert (this.getApi().deleteBucketIfEmpty("dbienf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteBucketIfEmptyButHasContents() throws Exception {
        String bucketName = this.getContainerName();
        try {
            this.addBlobToContainer(bucketName, "test");
            assert (!this.getApi().deleteBucketIfEmpty(bucketName));
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrivateAclIsDefaultForBucket() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String bucketName = this.getContainerName();
        try {
            AccessControlList acl = this.getApi().getBucketACL(bucketName);
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertNotNull((Object)acl.getOwner());
            String ownerId = acl.getOwner().getId();
            Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateBucketACL() throws InterruptedException, ExecutionException, TimeoutException, IOException, Exception {
        String bucketName = this.getContainerName();
        try {
            AccessControlList acl = this.getApi().getBucketACL(bucketName);
            String ownerId = acl.getOwner().getId();
            Assert.assertEquals((int)acl.getGrants().size(), (int)1);
            Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
            this.addGrantsToACL(acl);
            Assert.assertEquals((int)acl.getGrants().size(), (int)4);
            Assert.assertTrue((boolean)this.getApi().putBucketACL(bucketName, acl));
            acl = this.getApi().getBucketACL(bucketName);
            this.checkGrants(acl);
        }
        finally {
            this.destroyContainer(bucketName);
        }
    }

    private void checkGrants(AccessControlList acl) {
        String ownerId = acl.getOwner().getId();
        Assert.assertEquals((int)acl.getGrants().size(), (int)4, (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "WRITE_ACP"), (String)acl.toString());
        Assert.assertTrue((boolean)acl.hasPermission("1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c", "READ_ACP"), (String)acl.toString());
    }

    private void addGrantsToACL(AccessControlList acl) {
        String ownerId = acl.getOwner().getId();
        acl.addPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ");
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("james@misterm.org"), "READ_ACP");
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.CanonicalUserGrantee(ownerId), "WRITE_ACP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublicReadAccessPolicy() throws Exception {
        String bucketName = this.getScratchContainerName();
        try {
            this.getApi().putBucketInRegion(null, bucketName, new PutBucketOptions[]{PutBucketOptions.Builder.withBucketAcl((CannedAccessPolicy)CannedAccessPolicy.PUBLIC_READ)});
            AccessControlList acl = this.getApi().getBucketACL(bucketName);
            Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"), (String)acl.toString());
        }
        finally {
            this.destroyContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IOException.class})
    public void testDefaultAccessPolicy() throws Exception {
        String bucketName = this.getContainerName();
        try {
            URL url = new URL(String.format("https://%s.s3.amazonaws.com", bucketName));
            Strings2.toStringAndClose((InputStream)url.openStream());
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBucketPayer() throws Exception {
        final String bucketName = this.getContainerName();
        try {
            Assert.assertEquals((Object)Payer.BUCKET_OWNER, (Object)this.getApi().getBucketPayer(bucketName));
            this.getApi().setBucketPayer(bucketName, Payer.REQUESTER);
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        Assert.assertEquals((Object)Payer.REQUESTER, (Object)BucketsLiveTest.this.getApi().getBucketPayer(bucketName));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
            this.getApi().setBucketPayer(bucketName, Payer.BUCKET_OWNER);
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        Assert.assertEquals((Object)Payer.BUCKET_OWNER, (Object)BucketsLiveTest.this.getApi().getBucketPayer(bucketName));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
        }
        finally {
            this.destroyContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBucketLogging() throws Exception {
        final String bucketName = this.getContainerName();
        String targetBucket = this.getContainerName();
        try {
            Assert.assertNull((Object)this.getApi().getBucketLogging(bucketName));
            this.setupAclForBucketLoggingTarget(targetBucket);
            final BucketLogging logging = new BucketLogging(targetBucket, "access_log-", (Iterable)ImmutableSet.of((Object)new AccessControlList.Grant((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("james@misterm.org"), "FULL_CONTROL")));
            this.getApi().enableBucketLogging(bucketName, logging);
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        BucketLogging newLogging = BucketsLiveTest.this.getApi().getBucketLogging(bucketName);
                        assert (newLogging != null);
                        AccessControlList acl = new AccessControlList();
                        for (AccessControlList.Grant grant : newLogging.getTargetGrants()) {
                            acl.addPermission(grant.getGrantee(), grant.getPermission());
                        }
                        Assert.assertTrue((boolean)acl.hasPermission("1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c", "FULL_CONTROL"), (String)acl.toString());
                        Assert.assertEquals((String)logging.getTargetBucket(), (String)newLogging.getTargetBucket());
                        Assert.assertEquals((String)logging.getTargetPrefix(), (String)newLogging.getTargetPrefix());
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
            this.getApi().disableBucketLogging(bucketName);
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    try {
                        Assert.assertNull((Object)BucketsLiveTest.this.getApi().getBucketLogging(bucketName));
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                    }
                }
            });
        }
        finally {
            this.destroyContainer(bucketName);
            this.destroyContainer(targetBucket);
        }
    }

    private void setupAclForBucketLoggingTarget(String targetBucket) {
        AccessControlList acl = this.getApi().getBucketACL(targetBucket);
        acl.addPermission(AccessControlList.GroupGranteeURI.LOG_DELIVERY, "WRITE");
        acl.addPermission(AccessControlList.GroupGranteeURI.LOG_DELIVERY, "READ_ACP");
        Assert.assertTrue((boolean)this.getApi().putBucketACL(targetBucket, acl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bucketExists() throws Exception {
        String bucketName = this.getContainerName();
        try {
            Set list = this.getApi().listOwnedBuckets();
            BucketMetadata firstBucket = (BucketMetadata)Iterables.get((Iterable)list, (int)0);
            BucketMetadata toMatch = new BucketMetadata(bucketName, new Date(), firstBucket.getOwner());
            assert (list.contains(toMatch));
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    protected void addAlphabetUnderRoot(String bucketName) {
        for (char letter = 'a'; letter <= 'z'; letter = (char)(letter + '\u0001')) {
            S3Object blob = this.getApi().newS3Object();
            blob.getMetadata().setKey(letter + "");
            blob.setPayload(letter + "content");
            this.getApi().putObject(bucketName, blob, new PutObjectOptions[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListBucketMarker() throws InterruptedException, ExecutionException, TimeoutException {
        String bucketName = this.getContainerName();
        try {
            this.addAlphabetUnderRoot(bucketName);
            ListBucketResponse bucket = this.getApi().listBucket(bucketName, new ListBucketOptions[]{ListBucketOptions.Builder.afterMarker((String)"y")});
            Assert.assertEquals((String)bucket.getMarker(), (String)"y");
            assert (!bucket.isTruncated());
            Assert.assertEquals((int)bucket.size(), (int)1);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListBucketDelimiter() throws InterruptedException, ExecutionException, TimeoutException {
        String bucketName = this.getContainerName();
        try {
            String prefix = "apps";
            this.addTenObjectsUnderPrefix(bucketName, prefix);
            this.add15UnderRoot(bucketName);
            ListBucketResponse bucket = this.getApi().listBucket(bucketName, new ListBucketOptions[]{ListBucketOptions.Builder.delimiter((String)"/")});
            Assert.assertEquals((String)bucket.getDelimiter(), (String)"/");
            assert (!bucket.isTruncated());
            Assert.assertEquals((int)bucket.size(), (int)15);
            Assert.assertEquals((int)bucket.getCommonPrefixes().size(), (int)1);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListBucketPrefix() throws InterruptedException, ExecutionException, TimeoutException {
        String bucketName = this.getContainerName();
        try {
            String prefix = "apps";
            this.addTenObjectsUnderPrefix(bucketName, prefix);
            this.add15UnderRoot(bucketName);
            ListBucketResponse bucket = this.getApi().listBucket(bucketName, new ListBucketOptions[]{ListBucketOptions.Builder.withPrefix((String)"apps/")});
            assert (!bucket.isTruncated());
            Assert.assertEquals((int)bucket.size(), (int)10);
            Assert.assertEquals((String)bucket.getPrefix(), (String)"apps/");
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListBucketMaxResults() throws InterruptedException, ExecutionException, TimeoutException {
        String bucketName = this.getContainerName();
        try {
            this.addAlphabetUnderRoot(bucketName);
            ListBucketResponse bucket = this.getApi().listBucket(bucketName, new ListBucketOptions[]{ListBucketOptions.Builder.maxResults((int)5)});
            Assert.assertEquals((int)bucket.getMaxKeys(), (int)5);
            assert (bucket.isTruncated());
            Assert.assertEquals((int)bucket.size(), (int)5);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    protected void add15UnderRoot(String bucketName) {
        for (int i = 0; i < 15; ++i) {
            S3Object blob = this.getApi().newS3Object();
            blob.getMetadata().setKey(i + "");
            blob.setPayload(i + "content");
            this.getApi().putObject(bucketName, blob, new PutObjectOptions[0]);
        }
    }

    protected void addTenObjectsUnderPrefix(String bucketName, String prefix) {
        for (int i = 0; i < 10; ++i) {
            S3Object blob = this.getApi().newS3Object();
            blob.getMetadata().setKey(prefix + "/" + i);
            blob.setPayload(i + "content");
            this.getApi().putObject(bucketName, blob, new PutObjectOptions[0]);
        }
    }
}

