/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import org.jclouds.servermanager.Hardware;
import org.jclouds.servermanager.Image;
import org.jclouds.servermanager.Server;

@Singleton
public class ServerManager {
    private static final Map<Integer, Server> servers = Maps.newHashMap();
    private static final Map<Integer, Image> images = ImmutableMap.of((Object)1, (Object)new Image(1, "ubuntu"));
    private static final Map<Integer, Hardware> hardware = ImmutableMap.of((Object)1, (Object)new Hardware(1, "small", 1, 512, 10.0f));
    private static final AtomicInteger nodeIds = new AtomicInteger(0);

    public Server createServerInDC(String datacenter, String name, int imageId, int hardwareId) {
        Server server = new Server();
        server.id = nodeIds.getAndIncrement();
        server.name = name;
        server.datacenter = datacenter;
        server.imageId = imageId;
        server.hardwareId = hardwareId;
        server.publicAddress = "7.1.1." + server.id;
        server.privateAddress = "10.1.1." + server.id;
        server.loginUser = "root";
        server.password = "password";
        servers.put(server.id, server);
        return server;
    }

    public Server getServer(int serverId) {
        return servers.get(serverId);
    }

    public Iterable<Server> listServers() {
        return servers.values();
    }

    public Image getImage(int imageId) {
        return images.get(imageId);
    }

    public Iterable<Image> listImages() {
        return images.values();
    }

    public Hardware getHardware(int hardwareId) {
        return hardware.get(hardwareId);
    }

    public Iterable<Hardware> listHardware() {
        return hardware.values();
    }

    public void destroyServer(int serverId) {
        servers.remove(serverId);
    }

    public void rebootServer(int serverId) {
    }

    public void stopServer(int serverId) {
    }

    public void startServer(int serverId) {
    }
}

