/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCodes;
import com.google.common.io.BaseEncoding;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.xml.ReceiveMessageResponseHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ReceiveMessageResponseTest")
public class ReceiveMessageResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/messages.xml");
        FluentIterable<Message> expected = this.expected();
        ReceiveMessageResponseHandler handler = (ReceiveMessageResponseHandler)this.injector.getInstance(ReceiveMessageResponseHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public FluentIterable<Message> expected() {
        return FluentIterable.from((Iterable)ImmutableList.of((Object)Message.builder().id("5fea7756-0ea4-451a-a703-a558b933e274").receiptHandle("+eXJYhj5rDr9cAe/9BuheT5fysi9BoqtEZSkO7IazVbNHg60eCCINxLqaSVv2pFHrWeWNpZwbleSkWRbCtZaQGgpOx/3cWJZiNSG1KKlJX4IOwISFvb3FwByMx4w0lnINeXzcw2VcKQXNrCatO9gdIiVPvJC3SCKatYM/7YTidtjqc8igrtYW2E2mHlCy3NXPCeXxP4tSvyEwIxpDAmMT7IF0mWvTHS6+JBUtFUsrmi61oIHlESNrD1OjdB1QQw+kdvJ6VbsntbJNNYKw+YqdqWNpZkiGQ8y1z9OdHsr1+4=").md5(HashCodes.fromBytes((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)"fafb00f5732ab283681e124bf8747ed1"))).body("This is a test message").addAttribute("SenderId", "195004372649").addAttribute("SentTimestamp", "1238099229000").addAttribute("ApproximateReceiveCount", "5").addAttribute("ApproximateFirstReceiveTimestamp", "1250700979248").build()));
    }
}

