/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.internal.BaseBlobSignerExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.CommonSwiftClientTest;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SwiftBlobSignerExpectTest")
public class SwiftBlobSignerExpectTest
extends BaseBlobSignerExpectTest {
    public SwiftBlobSignerExpectTest() {
        this.identity = "test:tester";
        this.credential = "testing";
    }

    protected HttpRequest getBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://storage/container/name").addHeader("X-Auth-Token", new String[]{"testtoken"})).build();
    }

    protected HttpRequest getBlobWithTime() {
        return HttpRequest.builder().method("GET").endpoint("http://storage/container/name?temp_url_sig=2abd47f6b1c159fe9a45c873aaade8eeeb36a2e1&temp_url_expires=123456792").build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://storage/container/name").addHeader("X-Auth-Token", new String[]{"testtoken"})).addHeader("Range", new String[]{"bytes=0-1"})).build();
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://storage/container/name").addHeader("ETag", new String[]{"00020408"})).addHeader("Expect", new String[]{"100-continue"})).addHeader("X-Auth-Token", new String[]{"testtoken"})).build();
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://storage/container/name?temp_url_sig=e894c60fa1284cc575cf22d7786bab07b8c33610&temp_url_expires=123456792").addHeader("Expect", new String[]{"100-continue"})).build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("http://storage/container/name").addHeader("X-Auth-Token", new String[]{"testtoken"})).build();
    }

    protected Map<HttpRequest, HttpResponse> init() {
        HttpRequest authRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://auth/v1.0").addHeader("X-Auth-User", new String[]{this.identity})).addHeader("X-Auth-Key", new String[]{this.credential})).addHeader("Accept", new String[]{"*/*"})).addHeader("Host", new String[]{"myhost:8080"})).build();
        HttpResponse authResponse = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").addHeader("X-Storage-Url", new String[]{"http://storage"})).addHeader("X-Auth-Token", new String[]{"testtoken"})).build();
        HttpRequest temporaryKeyRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("http://storage/").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{"testtoken"})).build();
        HttpResponse temporaryKeyResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("X-Account-Meta-Temp-Url-Key", new String[]{"TEMPORARY_KEY"})).build();
        return ImmutableMap.builder().put((Object)authRequest, (Object)authResponse).put((Object)temporaryKeyRequest, (Object)temporaryKeyResponse).build();
    }

    protected ApiMetadata createApiMetadata() {
        return ((SwiftApiMetadata.Builder)((SwiftApiMetadata.Builder)new SwiftApiMetadata().toBuilder().defaultEndpoint("http://auth")).defaultModules((Set)ImmutableSet.builder().add(CommonSwiftClientTest.StorageEndpointModule.class).add(SwiftRestClientModule.class).add(SwiftBlobStoreContextModule.class).add(StaticTimeAndTemporaryUrlKeyModule.class).build())).build();
    }

    public static class StaticTimeAndTemporaryUrlKeyModule
    extends TemporaryUrlExtensionModule.SwiftTemporaryUrlExtensionModule {
        protected Long unixEpochTimestampProvider() {
            return 123456789L;
        }
    }
}

