/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import org.jclouds.openstack.swift.blobstore.SwiftBlobStore;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SwiftBlobStoreTest {
    @Test
    public void testSplitContainerAndKey() {
        String container = "test-container";
        String key = "key/with/some/slashes/in/it/and/a/trailing/slash/";
        String containerAndKey = container + "/" + key;
        String[] split = SwiftBlobStore.splitContainerAndKey((String)containerAndKey);
        String actualContainer = split[0];
        String actualKey = split[1];
        Assert.assertEquals((String)actualContainer, (String)container);
        Assert.assertEquals((String)actualKey, (String)key);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="No / separator found in \"not-a-container-and-key\"")
    public void testSplitContainerAndKeyWithNoSeparator() {
        SwiftBlobStore.splitContainerAndKey((String)"not-a-container-and-key");
    }
}

