/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.internal.BaseBlobSignerExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.config.MappedAuthenticationApiModule;
import org.jclouds.openstack.swift.SwiftKeystoneApiMetadata;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.openstack.swift.config.SwiftKeystoneRestClientModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SwiftKeystoneBlobSignerExpectTest")
public class SwiftKeystoneBlobSignerExpectTest
extends BaseBlobSignerExpectTest {
    protected HttpRequest getBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
    }

    protected HttpRequest getBlobWithTime() {
        return HttpRequest.builder().method("GET").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name?temp_url_sig=fd9b09acbc3ce71182240503c803dda4902098a9&temp_url_expires=123456792").build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).addHeader("Range", new String[]{"bytes=0-1"})).build();
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("ETag", new String[]{"00020408"})).addHeader("Expect", new String[]{"100-continue"})).addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name?temp_url_sig=72e5f6ebafab2b3da0586198797e58fb7478211e&temp_url_expires=123456792").addHeader("Expect", new String[]{"100-continue"})).build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
    }

    protected Map<HttpRequest, HttpResponse> init() {
        HttpRequest authenticate = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost:5000/v2.0/tokens").addHeader("Accept", new String[]{"application/json"})).payload(SwiftKeystoneBlobSignerExpectTest.payloadFromStringWithContentType((String)"{\"auth\":{\"passwordCredentials\":{\"username\":\"identity\",\"password\":\"credential\"}}}", (String)"application/json"))).build();
        HttpResponse authenticationResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/keystoneAuthResponse.json", "application/json"))).build();
        HttpRequest temporaryKeyRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://objects.jclouds.org/v1.0/40806637803162/").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
        HttpResponse temporaryKeyResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("X-Account-Meta-Temp-Url-Key", new String[]{"TEMPORARY_KEY"})).build();
        return ImmutableMap.builder().put((Object)authenticate, (Object)authenticationResponse).put((Object)temporaryKeyRequest, (Object)temporaryKeyResponse).build();
    }

    protected ApiMetadata createApiMetadata() {
        return ((SwiftKeystoneApiMetadata.Builder)new SwiftKeystoneApiMetadata().toBuilder().defaultModules((Set)ImmutableSet.builder().add(MappedAuthenticationApiModule.class).add(SwiftRestClientModule.KeystoneStorageEndpointModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(SwiftKeystoneRestClientModule.class).add(SwiftBlobStoreContextModule.class).add(StaticTimeAndTemporaryUrlKeyModule.class).build())).build();
    }

    public static class StaticTimeAndTemporaryUrlKeyModule
    extends TemporaryUrlExtensionModule.SwiftKeystoneTemporaryUrlExtensionModule {
        public static final long UNIX_EPOCH_TIMESTAMP = 123456789L;

        protected Long unixEpochTimestampProvider() {
            return 123456789L;
        }
    }
}

