/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.strategy.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.QueueDispatcher;
import com.google.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.openstack.keystone.v2_0.internal.KeystoneFixture;
import org.jclouds.openstack.swift.blobstore.strategy.internal.SequentialMultipartUploadStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class SequentialMultipartUploadStrategyMockTest {
    String authRequestBody = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPassword("user", "password").getPayload().getRawContent().toString();
    String authResponse = KeystoneFixture.INSTANCE.responseWithAccess().getPayload().getRawContent().toString().replace("https://objects.jclouds.org/v1.0/40806637803162", "URL");
    String token = "Auth_4f173437e4b013bee56d1007";
    private static final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMPUDoesMultipart() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        AtomicReference<URL> url = this.setURLReplacingDispatcher(server);
        server.enqueue(new MockResponse().setResponseCode(200).setBody(this.authResponse));
        server.enqueue(new MockResponse().setResponseCode(200).addHeader("ETag", (Object)"a00"));
        server.enqueue(new MockResponse().setResponseCode(200).addHeader("ETag", (Object)"b00"));
        server.enqueue(new MockResponse().setResponseCode(200).addHeader("ETag", (Object)"fff"));
        server.play();
        url.set(server.getUrl("/"));
        byte[] bytes = "0123456789abcdef".getBytes(Charsets.US_ASCII);
        int partSize = bytes.length / 2;
        SequentialMultipartUploadStrategy api = SequentialMultipartUploadStrategyMockTest.mockSequentialMultipartUploadStrategy(url.get().toString(), partSize);
        try {
            Assert.assertEquals((String)api.execute("container", new BlobBuilderImpl().name("foo").payload(bytes).build()), (String)"fff");
        }
        finally {
            RecordedRequest authRequest = server.takeRequest();
            Assert.assertEquals((String)authRequest.getRequestLine(), (String)"POST /tokens HTTP/1.1");
            Assert.assertEquals((String)new String(authRequest.getBody()), (String)this.authRequestBody);
            Assert.assertEquals((String)authRequest.getHeader("Content-Length"), (String)String.valueOf(this.authRequestBody.length()));
            RecordedRequest part1 = server.takeRequest();
            Assert.assertEquals((String)part1.getRequestLine(), (String)"PUT /container/foo/1 HTTP/1.1");
            Assert.assertEquals((String)part1.getHeader("X-Auth-Token"), (String)this.token);
            Assert.assertEquals((String)part1.getHeader("Content-Length"), (String)String.valueOf(partSize));
            Assert.assertEquals((String)new String(part1.getBody()), (String)"01234567");
            RecordedRequest part2 = server.takeRequest();
            Assert.assertEquals((String)part2.getRequestLine(), (String)"PUT /container/foo/2 HTTP/1.1");
            Assert.assertEquals((String)part2.getHeader("X-Auth-Token"), (String)this.token);
            Assert.assertEquals((String)part2.getHeader("Content-Length"), (String)String.valueOf(partSize));
            Assert.assertEquals((String)new String(part2.getBody()), (String)"89abcdef");
            RecordedRequest manifest = server.takeRequest();
            Assert.assertEquals((String)manifest.getRequestLine(), (String)"PUT /container/foo HTTP/1.1");
            Assert.assertEquals((String)manifest.getHeader("X-Auth-Token"), (String)this.token);
            Assert.assertEquals((String)manifest.getHeader("Content-Length"), (String)"0");
            server.shutdown();
        }
    }

    static SequentialMultipartUploadStrategy mockSequentialMultipartUploadStrategy(String uri, int partSize) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.so-timeout", "0");
        overrides.setProperty("jclouds.max-retries", "1");
        overrides.setProperty("jclouds.mpu.parts.size", String.valueOf(partSize));
        return (SequentialMultipartUploadStrategy)ContextBuilder.newBuilder((String)"swift-keystone").credentials("user", "password").endpoint(uri).overrides(overrides).modules(modules).buildInjector().getInstance(SequentialMultipartUploadStrategy.class);
    }

    private AtomicReference<URL> setURLReplacingDispatcher(MockWebServer server) {
        final AtomicReference<URL> url = new AtomicReference<URL>();
        QueueDispatcher dispatcher = new QueueDispatcher(){
            protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                MockResponse response = this.responseQueue.take();
                if (response.getBody() != null) {
                    String newBody = new String(response.getBody()).replace("URL", ((URL)url.get()).toString());
                    response = response.setBody(newBody);
                }
                return response;
            }

            public void enqueueResponse(MockResponse response) {
                this.responseQueue.add(response);
            }
        };
        server.setDispatcher((Dispatcher)dispatcher);
        return url;
    }
}

