/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.swift.domain.internal.ObjectInfoImpl;
import org.jclouds.openstack.swift.functions.ParseObjectInfoListFromJsonResponse;
import org.jclouds.openstack.swift.internal.BasePayloadTest;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseObjectInfoListFromJsonResponseTest
extends BasePayloadTest {
    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_container.json");
        ImmutableSet expects = ImmutableSet.of((Object)ObjectInfoImpl.builder().container("container").name("test_obj_1").uri(URI.create("http://localhost/key/test_obj_1")).hash(BaseEncoding.base16().lowerCase().decode((CharSequence)"4281c348eaf83e70ddce0e07221c3d28")).bytes(Long.valueOf(14L)).contentType("application/octet-stream").lastModified(new SimpleDateFormatDateService().iso8601DateParse("2009-02-03T05:26:32.612Z")).build(), (Object)ObjectInfoImpl.builder().container("container").name("test_obj_2").uri(URI.create("http://localhost/key/test_obj_2")).hash(BaseEncoding.base16().lowerCase().decode((CharSequence)"b039efe731ad111bc1b0ef221c3849d0")).bytes(Long.valueOf(64L)).contentType("application/octet-stream").lastModified(new SimpleDateFormatDateService().iso8601DateParse("2009-02-03T05:26:32.612Z")).build());
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)"container", (Object)new ListContainerOptions[]{new ListContainerOptions()}));
        ParseObjectInfoListFromJsonResponse parser = (ParseObjectInfoListFromJsonResponse)this.i.getInstance(ParseObjectInfoListFromJsonResponse.class);
        parser.setContext((HttpRequest)request);
        Assert.assertEquals((String)parser.apply(is).toString(), (String)expects.toString());
    }
}

