/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.keystone;

import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.internal.KeystoneFixture;
import org.jclouds.openstack.swift.SwiftKeystoneClient;
import org.jclouds.openstack.swift.internal.BaseSwiftKeystoneExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccessKeyAndSecretKeyAndTenantIdAuthenticationExpectTest")
public class AccessKeyAndSecretKeyAndTenantIdAuthenticationExpectTest
extends BaseSwiftKeystoneExpectTest<SwiftKeystoneClient> {
    public AccessKeyAndSecretKeyAndTenantIdAuthenticationExpectTest() {
        this.identity = this.identityWithTenantId;
    }

    @Override
    protected Properties setupProperties() {
        Properties contextProperties = super.setupProperties();
        contextProperties.setProperty("jclouds.keystone.credential-type", "apiAccessKeyCredentials");
        contextProperties.setProperty("jclouds.keystone.tenant-id", KeystoneFixture.INSTANCE.getTenantId());
        return contextProperties;
    }

    public void testContainerExistsWhenResponseIs2xx() throws Exception {
        HttpRequest containerExists = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse containerExistsResponse = HttpResponse.builder().statusCode(200).build();
        SwiftKeystoneClient clientWhenContainerExists = (SwiftKeystoneClient)this.requestsSendResponses(this.keystoneAuthWithAccessKeyAndSecretKeyAndTenantId, this.responseWithKeystoneAccess, containerExists, containerExistsResponse);
        Assert.assertEquals((boolean)clientWhenContainerExists.containerExists("container"), (boolean)true);
    }
}

