/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.jclouds.openstack.swift.options.CreateContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateContainerOptionsTest {
    public void testPublicAccess() {
        CreateContainerOptions options = new CreateContainerOptions().withPublicAccess();
        Assert.assertEquals((Collection)ImmutableList.of((Object)".r:*,.rlistings"), (Collection)options.buildRequestHeaders().get((Object)"X-Container-Read"));
    }

    public void testPublicAccessStatic() {
        CreateContainerOptions options = CreateContainerOptions.Builder.withPublicAccess();
        Assert.assertEquals((Collection)ImmutableList.of((Object)".r:*,.rlistings"), (Collection)options.buildRequestHeaders().get((Object)"X-Container-Read"));
    }

    public void testMetadata() {
        CreateContainerOptions options = new CreateContainerOptions().withMetadata((Map)ImmutableMap.of((Object)"test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-test"));
    }

    public void testMetadataAlreadyPrefixed() {
        CreateContainerOptions options = new CreateContainerOptions().withMetadata((Map)ImmutableMap.of((Object)"X-Container-Meta-test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-test"));
    }

    public void testMetadataStatic() {
        CreateContainerOptions options = CreateContainerOptions.Builder.withMetadata((Map)ImmutableMap.of((Object)"test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-test"));
    }
}

