/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.handlers;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.azure.storage.AzureStorageResponseException;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.handlers.ParseAzureStorageErrorFromXmlContent;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseAzureErrorFromXmlContentTest {
    @Test
    public void test411WithTextHtmlIllegalArgumentException() {
        this.assertCodeMakes("PUT", URI.create("https://jclouds.blob.core.windows.net/adriancole-azureblob-413790770?restype=container"), 411, "Length Required", "text/html; charset=us-ascii", "<HTML><HEAD><TITLE>Length Required</TITLE>\r\n", IllegalArgumentException.class);
    }

    @Test
    public void test304WithNoContentIllegalArgumentException() {
        this.assertCodeMakes("GET", URI.create("https://jclouds.blob.core.windows.net/adriancole-blobstore0/apples"), 411, "HTTP/1.1 304 The condition specified using HTTP conditional header(s) is not met.", "application/unknown", "", IllegalArgumentException.class);
    }

    @Test
    public void test412WithTextHtmlHttpResponseException() {
        this.assertCodeMakes("GET", URI.create("https://jclouds.blob.core.windows.net/adriancole-blobstore2?restype=container&comp=list&prefix=apps/apps/apps/&include=metadata"), 412, "HTTP/1.1 412 The condition specified using HTTP conditional header(s) is not met.", "application/xml", "<?xml version=\"1.0\" encoding=\"utf-8\"?><Error><Code>ConditionNotMet</Code><Message>The condition specified using HTTP conditional header(s) is not met.\nRequestId:921efcad-84bc-4e0a-863d-24810d1096e1\nTime:2010-11-04T15:03:07.8694513Z</Message></Error>", AzureStorageResponseException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        ParseAzureStorageErrorFromXmlContent function = (ParseAzureStorageErrorFromXmlContent)Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind(SharedKeyLiteAuthentication.class).toInstance(EasyMock.createMock(SharedKeyLiteAuthentication.class));
            }
        }}).getInstance(ParseAzureStorageErrorFromXmlContent.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(ParseAzureErrorFromXmlContentTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

