/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.azure.storage.options.CreateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateOptionsTest {
    public void testMetadata() {
        CreateOptions options = new CreateOptions().withMetadata((Multimap)ImmutableMultimap.of((Object)"test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-meta-test"));
    }

    public void testMetadataAlreadyPrefixed() {
        CreateOptions options = new CreateOptions().withMetadata((Multimap)ImmutableMultimap.of((Object)"x-ms-meta-test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-meta-test"));
    }

    public void testMetadataStatic() {
        CreateOptions options = CreateOptions.Builder.withMetadata((Multimap)ImmutableMultimap.of((Object)"test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-meta-test"));
    }
}

