/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.handlers;

import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.azure.storage.AzureStorageResponseException;
import org.jclouds.azure.storage.domain.AzureStorageError;
import org.jclouds.azure.storage.util.AzureStorageUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

public class ParseAzureStorageErrorFromXmlContent
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final AzureStorageUtils utils;
    public static final Pattern CONTAINER_PATH = Pattern.compile("^[/]?([^/]+)$");
    public static final Pattern CONTAINER_KEY_PATH = Pattern.compile("^[/]?([^/]+)/(.*)$");

    @Inject
    public ParseAzureStorageErrorFromXmlContent(AzureStorageUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        Object exception = new HttpResponseException(command, response);
        String message = null;
        AzureStorageError error = null;
        try {
            if (response.getPayload() != null) {
                String contentType = response.getPayload().getContentMetadata().getContentType();
                if (!(contentType == null || contentType.indexOf("xml") == -1 && contentType.indexOf("unknown") == -1 || Long.valueOf(0L).equals(response.getPayload().getContentMetadata().getContentLength()))) {
                    try {
                        error = this.utils.parseAzureStorageErrorFromContent(command, response, response.getPayload().getInput());
                        if (error != null) {
                            message = error.getMessage();
                            exception = new AzureStorageResponseException(command, response, error);
                        }
                    }
                    catch (RuntimeException e) {
                        try {
                            message = Strings2.toString((InputSupplier)response.getPayload());
                            exception = new HttpResponseException(command, response, message);
                        }
                        catch (IOException e1) {}
                    }
                } else {
                    try {
                        message = Strings2.toString((InputSupplier)response.getPayload());
                        exception = new HttpResponseException(command, response, message);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            exception = this.refineException(command, response, (Exception)exception, error, message);
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)exception);
        }
    }

    protected Exception refineException(HttpCommand command, HttpResponse response, Exception exception, AzureStorageError error, String message) {
        switch (response.getStatusCode()) {
            case 401: {
                exception = new AuthorizationException(message, (Throwable)exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, (Throwable)exception);
                break;
            }
            case 411: {
                exception = new IllegalArgumentException(message);
            }
        }
        return exception;
    }
}

