/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.functions;

import java.net.URI;
import org.jclouds.openstack.keystone.v1_1.domain.Endpoint;
import org.jclouds.openstack.keystone.v1_1.functions.RegionFirstPartOfDNSNameOrProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionFirstPartOfDNSNameOrProviderTest")
public class RegionFirstPartOfDNSNameOrProviderTest {
    private final RegionFirstPartOfDNSNameOrProvider fn = new RegionFirstPartOfDNSNameOrProvider("keystone");

    public void testRegionNotNullReturnsRegion() {
        Assert.assertEquals((String)this.fn.apply(Endpoint.builder().region("LON").publicURL(URI.create("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953")).v1Default(true).build()), (String)"LON");
    }

    public void testRegionNullReturnsFirstPartOfHostWhenValid() {
        Assert.assertEquals((String)this.fn.apply(Endpoint.builder().publicURL(URI.create("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953")).v1Default(true).build()), (String)"cdn3");
    }

    public void testRegionNullReturnsProvioderWhenHostNotValid() {
        Assert.assertEquals((String)this.fn.apply(Endpoint.builder().publicURL(URI.create("https://1.1.1.4")).v1Default(true).build()), (String)"keystone");
    }
}

