/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.ImplicitRegionIdSupplier;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.parse.ParseAuthTest;
import org.jclouds.openstack.keystone.v1_1.suppliers.V1DefaultRegionIdSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="V1DefaultRegionIdSupplierTest")
public class V1DefaultRegionIdSupplierTest {
    private final V1DefaultRegionIdSupplier.Factory factory = (V1DefaultRegionIdSupplier.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("keystone");
            this.install(new FactoryModuleBuilder().implement(ImplicitRegionIdSupplier.class, V1DefaultRegionIdSupplier.class).build(V1DefaultRegionIdSupplier.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Auth> provide() {
            return Suppliers.ofInstance((Object)new ParseAuthTest().expected());
        }
    }}).getInstance(V1DefaultRegionIdSupplier.Factory.class);

    public void testRegionMatches() {
        Assert.assertEquals((String)((String)this.factory.createForApiType("cloudFilesCDN").get()), (String)"LON");
    }

    public void testTakesFirstPartOfDNSWhenNoRegion() {
        Assert.assertEquals((String)((String)this.factory.createForApiType("cloudServers").get()), (String)"lon");
    }
}

