/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindAddInternetServiceToXmlPayload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindAddInternetServiceToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.terremark.extension.ns")).to("urn:tmrk:vCloudExpressExtensions-1.6");
        }

        @Singleton
        @Provides
        @Named(value="CreateInternetService")
        String provideInstantiateVAppTemplateParams() throws IOException {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService.xml");
            return Strings2.toStringAndClose((InputStream)is);
        }
    }});

    public void testApplyInputStream() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/CreateInternetService-test.xml"));
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://test").build();
        BindAddInternetServiceToXmlPayload binder = (BindAddInternetServiceToXmlPayload)this.injector.getInstance(BindAddInternetServiceToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "name");
        map.put("protocol", "TCP");
        map.put("port", "22");
        map.put("enabled", "true");
        map.put("description", "name TCP 22");
        binder.bindToRequest(request, (Map)map);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)expected);
    }

    public void testDisableMonitoringEnabled() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://test").build();
        BindAddInternetServiceToXmlPayload binder = (BindAddInternetServiceToXmlPayload)this.injector.getInstance(BindAddInternetServiceToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "name");
        map.put("protocol", "TCP");
        map.put("port", "22");
        map.put("enabled", "true");
        map.put("monitor", "true");
        binder.bindToRequest(request, (Map)map);
        String rawContent = (String)request.getPayload().getRawContent();
        Assert.assertEquals((int)-1, (int)rawContent.indexOf("<MonitorType>Disabled</MonitorType>"));
    }

    public void testDisableMonitoringDisabled() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://test").build();
        BindAddInternetServiceToXmlPayload binder = (BindAddInternetServiceToXmlPayload)this.injector.getInstance(BindAddInternetServiceToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "name");
        map.put("protocol", "TCP");
        map.put("port", "22");
        map.put("enabled", "true");
        map.put("monitor", "false");
        binder.bindToRequest(request, (Map)map);
        String rawContent = (String)request.getPayload().getRawContent();
        Assert.assertNotEquals((Object)-1, (Object)rawContent.indexOf("<MonitorType>Disabled</MonitorType>"));
    }
}

