/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindAddNodeServiceToXmlPayload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindAddNodeServiceToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.terremark.extension.ns")).to("urn:tmrk:vCloudExpressExtensions-1.6");
        }

        @Singleton
        @Provides
        @Named(value="CreateNodeService")
        String provideInstantiateVAppTemplateParams() throws IOException {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/CreateNodeService.xml");
            return Strings2.toStringAndClose((InputStream)is);
        }
    }});

    public void testApplyInputStream() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/CreateNodeService-test.xml"));
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://test").build();
        BindAddNodeServiceToXmlPayload binder = (BindAddNodeServiceToXmlPayload)this.injector.getInstance(BindAddNodeServiceToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "Node for Jim");
        map.put("ipAddress", "172.16.20.3");
        map.put("port", "80");
        map.put("enabled", "false");
        map.put("description", "Some test node");
        Assert.assertEquals((Object)binder.bindToRequest(request, (Map)map).getPayload().getRawContent(), (Object)expected);
    }
}

