/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindVAppConfigurationToXmlPayload;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VAppConfiguration;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VAppImpl;
import org.jclouds.trmk.vcloud_0_8.internal.BasePayloadTest;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudApiMetadata;
import org.jclouds.util.Strings2;
import org.nnsoft.guice.rocoto.Rocoto;
import org.nnsoft.guice.rocoto.configuration.ConfigurationModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindVAppConfigurationToXmlPayloadTest
extends BasePayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{Rocoto.expandVariables((Module[])new Module[]{new ConfigurationModule(){

        protected void bindConfigurations() {
            this.bind(String.class).annotatedWith(ApiVersion.class).toInstance((Object)"0.8");
            this.bindProperties(TerremarkVCloudApiMetadata.defaultProperties());
        }
    }})});

    public void testChangeName() throws IOException {
        VAppImpl vApp = new VAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(2L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(1024L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("foo").addressOnParent("0").hostResource("1048576").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(Long.valueOf(209152L)).build()));
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/configureVApp.xml")).replace("eduardo", "roberto");
        VAppConfiguration config = new VAppConfiguration().changeNameTo("roberto");
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)vApp, (Object)config));
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testRemoveDisk() throws IOException {
        VAppImpl vApp = new VAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(2L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(1024L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("foo").addressOnParent("0").hostResource("1048576").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(Long.valueOf(209152L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("foo").addressOnParent("1").hostResource("1048576").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(Long.valueOf(209152L)).build()));
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/configureVApp.xml")).replace("eduardo", "MyAppServer6");
        VAppConfiguration config = new VAppConfiguration().deleteDiskWithAddressOnParent(1);
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)vApp, (Object)config));
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testChangeAll() throws IOException {
        VAppImpl vApp = new VAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(2L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(1024L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("foo").addressOnParent("0").hostResource("1048576").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(Long.valueOf(209152L)).build()));
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/configureVAppAll.xml"));
        VAppConfiguration config = VAppConfiguration.Builder.changeNameTo((String)"eduardo").changeMemoryTo(1536L).changeProcessorCountTo(1).addDisk(0x1900000L).addDisk(0x1900000L);
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)vApp, (Object)config));
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testChangeCPUCountTo4() throws IOException {
        VAppImpl vApp = new VAppImpl("eduardo", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(4L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(1024L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("foo").addressOnParent("0").hostResource("1048576").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(Long.valueOf(209152L)).build()));
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/configureVApp4.xml"));
        VAppConfiguration config = new VAppConfiguration().changeProcessorCountTo(4);
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)vApp, (Object)config));
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testChangeMemoryTo1536() throws IOException {
        VAppImpl vApp = new VAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(2L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("foo").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(1536L)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("foo").addressOnParent("0").hostResource("1048576").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(Long.valueOf(209152L)).build()));
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/configureVApp.xml")).replace("eduardo", "MyAppServer6").replace("1024", "1536");
        VAppConfiguration config = new VAppConfiguration().changeMemoryTo(1536L);
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)vApp, (Object)config));
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }
}

