/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PopulateDefaultLoginCredentialsForVAppTemplateTest {
    @Test
    public void testRhel() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/rhel_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        LoginCredentials creds = converter.apply((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"vcloud");
        Assert.assertEquals((String)creds.credential, (String)"$Ep455l0ud!2");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testLamp() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/lamp_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        LoginCredentials creds = converter.apply((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"ecloud");
        Assert.assertEquals((String)creds.credential, (String)"$Ep455l0ud!2");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testFt() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/ft_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        LoginCredentials creds = converter.apply((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"vpncubed");
        Assert.assertEquals((String)creds.credential, (String)"vpncubed");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testEC() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/ec_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        LoginCredentials creds = converter.apply((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"ecloud");
        Assert.assertEquals((String)creds.credential, (String)"TmrkCl0ud1s#1!");
        EasyMock.verify((Object[])new Object[]{template});
    }

    @Test
    public void testWindows() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/windows_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{template});
        ParseVAppTemplateDescriptionToGetDefaultLoginCredentials converter = new ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        LoginCredentials creds = converter.apply((Object)template);
        Assert.assertEquals((String)creds.identity, (String)"Administrator");
        Assert.assertEquals((String)creds.credential, null);
        EasyMock.verify((Object[])new Object[]{template});
    }
}

