/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.internal;

import com.google.common.base.Predicate;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.util.Predicates2;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true)
public abstract class BaseTerremarkClientLiveTest
extends BaseComputeServiceContextLiveTest {
    protected String prefix = System.getProperty("user.name");
    protected ComputeService client;
    protected Predicate<HostAndPort> socketTester;
    protected SshClient.Factory sshFactory;
    protected TerremarkVCloudClient api;

    public BaseTerremarkClientLiveTest() {
        this.provider = "trmk-ecloud";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        Injector injector = ((ComputeServiceContext)this.view).utils().injector();
        SocketOpen socketOpen = (SocketOpen)injector.getInstance(SocketOpen.class);
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)300L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        this.api = (TerremarkVCloudClient)injector.getInstance(TerremarkVCloudClient.class);
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

