/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.options;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.FenceMode;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InstantiateVAppTemplateOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});

    @Test
    public void testCustomizeOnInstantiate() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.customizeOnInstantiate(true);
        Assert.assertEquals((Object)options.shouldCustomizeOnInstantiate(), (Object)Boolean.TRUE);
    }

    @Test
    public void testCustomizeOnInstantiateStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.customizeOnInstantiate((Boolean)true);
        Assert.assertEquals((Object)options.shouldCustomizeOnInstantiate(), (Object)Boolean.TRUE);
    }

    @Test
    public void testRam() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.memory(512L);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test
    public void testRamStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.memory((int)512);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test
    public void testInGroup() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.inGroup("group1");
        Assert.assertEquals((String)((String)options.getProperties().get("group")), (String)"group1");
    }

    @Test
    public void testInGroupStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.inGroup((String)"group1");
        Assert.assertEquals((String)((String)options.getProperties().get("group")), (String)"group1");
    }

    @Test
    public void testInRow() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.inRow("row1");
        Assert.assertEquals((String)((String)options.getProperties().get("row")), (String)"row1");
    }

    @Test
    public void testInRowStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.inRow((String)"row1");
        Assert.assertEquals((String)((String)options.getProperties().get("row")), (String)"row1");
    }

    @Test
    public void testWithPassword() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.withPassword("password1");
        Assert.assertEquals((String)((String)options.getProperties().get("password")), (String)"password1");
    }

    @Test
    public void testWithPasswordStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.withPassword((String)"password1");
        Assert.assertEquals((String)((String)options.getProperties().get("password")), (String)"password1");
    }

    @Test
    public void testAddNetworkConfig() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.addNetworkConfig(new InstantiateVAppTemplateOptions.NetworkConfig("default", URI.create("http://localhost"), FenceMode.ALLOW_IN_OUT));
        Assert.assertEquals((String)((InstantiateVAppTemplateOptions.NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((InstantiateVAppTemplateOptions.NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((InstantiateVAppTemplateOptions.NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.ALLOW_IN_OUT);
    }

    @Test
    public void testAddNetworkConfigStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.addNetworkConfig((InstantiateVAppTemplateOptions.NetworkConfig)new InstantiateVAppTemplateOptions.NetworkConfig("default", URI.create("http://localhost"), FenceMode.ALLOW_IN_OUT));
        Assert.assertEquals((String)((InstantiateVAppTemplateOptions.NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((InstantiateVAppTemplateOptions.NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((InstantiateVAppTemplateOptions.NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.ALLOW_IN_OUT);
    }

    @Test
    public void testCpuCount() {
        Assert.assertEquals((String)InstantiateVAppTemplateOptions.Builder.processorCount((int)3).getCpuCount(), (String)"3");
    }

    @Test
    public void testCpuCountStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.processorCount((int)3);
        Assert.assertEquals((String)options.getCpuCount(), (String)"3");
    }

    @Test
    public void testMegabytes() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.memory(512L);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }

    @Test
    public void testMegabytesStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.memory((int)512);
        Assert.assertEquals((String)options.getMemorySizeMegabytes(), (String)"512");
    }
}

