/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogItemImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudApiMetadata;
import org.jclouds.trmk.vcloud_0_8.xml.CatalogItemHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CatalogItemHandlerTest")
public class CatalogItemHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                Names.bindProperties((Binder)this.binder(), (Properties)TerremarkVCloudApiMetadata.defaultProperties());
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/catalogItem-terremark.xml");
        CatalogItem result = (CatalogItem)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(CatalogItemHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new CatalogItemImpl("Windows Web Server 2008 R2 (64-bit)", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/22"), null, (ReferenceType)new ReferenceTypeImpl("Compute Options", "application/xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/22/options/compute")), (ReferenceType)new ReferenceTypeImpl("Customization Options", "application/xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/22/options/customization")), (ReferenceType)new ReferenceTypeImpl("Windows Web Server 2008 R2 (64-bit)", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vAppTemplate/22")), (Map)ImmutableSortedMap.of((Comparable)((Object)"LicensingCost"), (Object)"0")));
    }
}

