/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.jclouds.cim.CIMPredicates;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.xml.VAppHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VAppHandlerTest")
public class VAppHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                Properties toBind = new Properties();
                toBind.setProperty("jclouds.api-version", "0.8");
                Names.bindProperties((Binder)this.binder(), (Properties)toBind);
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/launched_vapp.xml");
        VApp result = (VApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VAppHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"adriantest");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.UNRESOLVED);
        Assert.assertEquals((long)result.getSize(), (long)4L);
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/13775"));
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32")));
    }

    public void testGetVApp() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/get_vapp.xml");
        VApp result = (VApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VAppHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"centos-53");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((long)result.getSize(), (long)0xA00000L);
        Assert.assertEquals((String)result.getOperatingSystemDescription(), (String)"Red Hat Enterprise Linux 5 (64-bit)");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/16238"));
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32")));
        VirtualSystemSettingData system = VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("centos-53").virtualSystemType("vmx-07").build();
        Assert.assertEquals((String)result.getSystem().toString(), (String)system.toString());
        Assert.assertEquals((Collection)result.getNetworkToAddresses().get((Object)"Internal"), (Collection)ImmutableList.of((Object)"10.114.34.132"));
        ResourceAllocationSettingData cpu = ResourceAllocationSettingData.builder().instanceID("1").elementName("1 virtual CPU(s)").description("Number of Virtual CPUs").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(2L)).virtualQuantityUnits("hertz * 10^6").build();
        ResourceAllocationSettingData controller = ResourceAllocationSettingData.builder().instanceID("3").elementName("SCSI Controller 0").description("SCSI Controller").resourceType(ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA).resourceSubType("lsilogic").address("0").virtualQuantity(Long.valueOf(1L)).build();
        ResourceAllocationSettingData memory = ResourceAllocationSettingData.builder().instanceID("2").elementName("512MB of memory").description("Memory Size").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(512L)).virtualQuantityUnits("byte * 2^20").build();
        ResourceAllocationSettingData disk = ResourceAllocationSettingData.builder().instanceID("9").elementName("Hard Disk 1").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).hostResource("10485760").addressOnParent("0").virtualQuantity(Long.valueOf(0xA00000L)).virtualQuantityUnits("byte * 2^20").build();
        Assert.assertEquals((Set)result.getResourceAllocations(), (Set)ImmutableSet.of((Object)cpu, (Object)memory, (Object)controller, (Object)disk));
        Assert.assertEquals((int)((ResourceAllocationSettingData)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PROCESSOR}))).getVirtualQuantity().intValue(), (int)1);
        Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA}));
        Assert.assertEquals((int)((ResourceAllocationSettingData)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.MEMORY}))).getVirtualQuantity().intValue(), (int)512);
        Assert.assertEquals((long)((ResourceAllocationSettingData)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE}))).getVirtualQuantity(), (long)0xA00000L);
        Assert.assertEquals((long)result.getSize(), (long)((ResourceAllocationSettingData)Iterables.find((Iterable)result.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE}))).getVirtualQuantity());
    }

    public void testGetVApp2disks() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/get_vapp2disks.xml");
        VApp vApp = (VApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VAppHandler.class)).parse(is);
        Assert.assertEquals((String)vApp.getName(), (String)"eduardo");
        Assert.assertEquals((Object)vApp.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((long)vApp.getSize(), (long)0x1D00000L);
        Assert.assertEquals((String)vApp.getOperatingSystemDescription(), (String)"Ubuntu Linux (32-bit)");
        Assert.assertEquals((Object)vApp.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/15639"));
        Assert.assertEquals((Object)vApp.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32")));
        VirtualSystemSettingData system = VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("eduardo").virtualSystemType("vmx-07").build();
        Assert.assertEquals((String)vApp.getSystem().toString(), (String)system.toString());
        Assert.assertEquals((Collection)vApp.getNetworkToAddresses().get((Object)"Internal"), (Collection)ImmutableList.of((Object)"10.114.34.131"));
        ResourceAllocationSettingData cpu = ResourceAllocationSettingData.builder().instanceID("1").elementName("2 virtual CPU(s)").description("Number of Virtual CPUs").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(2L)).virtualQuantityUnits("hertz * 10^6").build();
        ResourceAllocationSettingData controller = ResourceAllocationSettingData.builder().instanceID("3").elementName("SCSI Controller 0").description("SCSI Controller").resourceType(ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA).resourceSubType("lsilogic").address("0").virtualQuantity(Long.valueOf(1L)).build();
        ResourceAllocationSettingData memory = ResourceAllocationSettingData.builder().instanceID("2").elementName("1024MB of memory").description("Memory Size").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(1024L)).virtualQuantityUnits("byte * 2^20").build();
        ResourceAllocationSettingData disk = ResourceAllocationSettingData.builder().instanceID("9").elementName("Hard Disk 1").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).hostResource("4194304").addressOnParent("0").virtualQuantity(Long.valueOf(0x400000L)).virtualQuantityUnits("byte * 2^20").build();
        ResourceAllocationSettingData disk2 = ResourceAllocationSettingData.builder().instanceID("9").elementName("Hard Disk 2").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).hostResource("26214400").addressOnParent("1").virtualQuantity(Long.valueOf(0x1900000L)).virtualQuantityUnits("byte * 2^20").build();
        Assert.assertEquals((Set)vApp.getResourceAllocations(), (Set)ImmutableSet.of((Object)cpu, (Object)memory, (Object)controller, (Object)disk, (Object)disk2));
        Assert.assertEquals((int)((ResourceAllocationSettingData)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PROCESSOR}))).getVirtualQuantity().intValue(), (int)2);
        Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA}));
        Assert.assertEquals((long)((ResourceAllocationSettingData)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.MEMORY}))).getVirtualQuantity(), (long)1024L);
        ArrayList disks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE})));
        Assert.assertEquals((long)((ResourceAllocationSettingData)disks.get(0)).getVirtualQuantity(), (long)0x400000L);
        Assert.assertEquals((long)((ResourceAllocationSettingData)disks.get(1)).getVirtualQuantity(), (long)0x1900000L);
    }
}

