/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml.ovf;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VAppImpl;
import org.jclouds.trmk.vcloud_0_8.xml.VAppHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VCloudExpressVAppHandlerTest")
public class VAppHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                Properties toBind = new Properties();
                toBind.setProperty("jclouds.api-version", "0.8");
                Names.bindProperties((Binder)this.binder(), (Properties)toBind);
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
    }

    public void testInstantiated() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/instantiatedvapp.xml");
        VApp result = (VApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VAppHandler.class)).parse(is);
        VAppImpl expects = new VAppImpl("centos53", URI.create("http://10.150.4.49/api/v0.8/vApp/10"), Status.RESOLVED, Long.valueOf(123456789L), (ReferenceType)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("http://10.150.4.49/api/v0.8/vdc/4")), (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of());
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testDefault() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/vapp.xml");
        VApp result = (VApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VAppHandler.class)).parse(is);
        ImmutableListMultimap networkToAddresses = ImmutableListMultimap.of((Object)"Public Network", (Object)"10.150.4.93");
        VirtualSystemSettingData system = VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("centos53").virtualSystemType("vmx-07").build();
        ImmutableSet resourceAllocations = ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("1 virtual CPU(s)").description("Number of Virtual CPUs").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(1L)).allocationUnits("hertz * 10^6").virtualQuantityUnits("count").build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("16MB of memory").description("Memory Size").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(16L)).allocationUnits("byte * 2^20").virtualQuantityUnits("byte * 2^20").build(), (Object)ResourceAllocationSettingData.builder().instanceID("3").elementName("SCSI Controller 0").description("SCSI Controller").resourceType(ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA).resourceSubType("lsilogic").address("0").build(), (Object)ResourceAllocationSettingData.builder().instanceID("8").elementName("Network Adapter 1").description("PCNet32 ethernet adapter on \"Internal\" network").resourceType(ResourceAllocationSettingData.ResourceType.ETHERNET_ADAPTER).resourceSubType("PCNet32").addressOnParent("7").connection("Internal").automaticAllocation(Boolean.valueOf(true)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("Hard Disk 1").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).hostResource("104857").addressOnParent("0").parent("3").virtualQuantity(Long.valueOf(104857L)).build());
        VAppImpl expects = new VAppImpl("centos53", URI.create("http://10.150.4.49/api/v0.8/vApp/10"), Status.ON, Long.valueOf(104857L), (ReferenceType)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("http://10.150.4.49/api/v0.8/vdc/4")), (ListMultimap)networkToAddresses, null, "Other Linux (32-bit)", system, (Set)resourceAllocations);
        Assert.assertEquals((Object)result.getHref(), (Object)expects.getHref());
        Assert.assertEquals((String)result.getName(), (String)expects.getName());
        Assert.assertEquals((Object)result.getNetworkToAddresses(), (Object)expects.getNetworkToAddresses());
        Assert.assertEquals((String)result.getOperatingSystemDescription(), (String)expects.getOperatingSystemDescription());
        Assert.assertEquals((String)result.getResourceAllocations().toString(), (String)expects.getResourceAllocations().toString());
        Assert.assertEquals((Object)result.getSize(), (Object)expects.getSize());
        Assert.assertEquals((Object)result.getStatus(), (Object)expects.getStatus());
        Assert.assertEquals((String)result.getSystem().toString(), (String)expects.getSystem().toString());
        Assert.assertEquals((String)result.getType(), (String)expects.getType());
        Assert.assertEquals((Object)result.getVDC(), (Object)expects.getVDC());
    }

    public void testLatest() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/vapp2.xml");
        VApp result = (VApp)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VAppHandler.class)).parse(is);
        ImmutableListMultimap networkToAddresses = ImmutableListMultimap.of((Object)"Public Network", (Object)"10.23.119.221");
        VirtualSystemSettingData system = VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("m1").virtualSystemType("vmx-07").build();
        ImmutableSet resourceAllocations = ImmutableSet.of((Object)ResourceAllocationSettingData.builder().instanceID("1").elementName("1 virtual CPU(s)").description("Number of Virtual CPUs").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(1L)).allocationUnits("hertz * 10^6").virtualQuantityUnits("count").build(), (Object)ResourceAllocationSettingData.builder().instanceID("2").elementName("512MB of memory").description("Memory Size").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(512L)).allocationUnits("byte * 2^20").virtualQuantityUnits("byte * 2^20").build(), (Object)ResourceAllocationSettingData.builder().instanceID("3").elementName("SCSI Controller 0").description("SCSI Controller").resourceType(ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA).resourceSubType("lsilogic").address("0").build(), (Object)ResourceAllocationSettingData.builder().instanceID("8").elementName("Network Adapter 1").description("PCNet32 ethernet adapter on \"Internal\" network").resourceType(ResourceAllocationSettingData.ResourceType.ETHERNET_ADAPTER).resourceSubType("PCNet32").addressOnParent("7").connection("Internal").automaticAllocation(Boolean.valueOf(true)).build(), (Object)ResourceAllocationSettingData.builder().instanceID("9").elementName("Hard Disk 1").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).hostResource("10485760").addressOnParent("0").parent("3").virtualQuantity(Long.valueOf(0xA00000L)).build());
        VAppImpl expects = new VAppImpl("m1", URI.create("http://localhost:8000/api/v0.8/vApp/80"), Status.ON, Long.valueOf(0xA00000L), (ReferenceType)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("http://localhost:8000/api/v0.8/vdc/28")), (ListMultimap)networkToAddresses, null, "Microsoft Windows XP Professional (32-bit)", system, (Set)resourceAllocations);
        Assert.assertEquals((Object)result.getHref(), (Object)expects.getHref());
        Assert.assertEquals((String)result.getName(), (String)expects.getName());
        Assert.assertEquals((Object)result.getNetworkToAddresses(), (Object)expects.getNetworkToAddresses());
        Assert.assertEquals((String)result.getOperatingSystemDescription(), (String)expects.getOperatingSystemDescription());
        Assert.assertEquals((String)result.getResourceAllocations().toString(), (String)expects.getResourceAllocations().toString());
        Assert.assertEquals((Object)result.getSize(), (Object)expects.getSize());
        Assert.assertEquals((Object)result.getStatus(), (Object)expects.getStatus());
        Assert.assertEquals((String)result.getSystem().toString(), (String)expects.getSystem().toString());
        Assert.assertEquals((String)result.getType(), (String)expects.getType());
        Assert.assertEquals((Object)result.getVDC(), (Object)expects.getVDC());
    }
}

