/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae;

import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.JcloudsVersion;
import org.jclouds.gae.ConvertToGaeRequest;
import org.jclouds.gae.ConvertToJcloudsResponse;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.internal.Wire;
import org.jclouds.util.Throwables2;

@Singleton
public class AsyncGaeHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HTTPRequest> {
    public static final String USER_AGENT = String.format("jclouds/%s urlfetch/%s", JcloudsVersion.get(), "1.6.5");
    private final URLFetchService urlFetchService;
    private final ConvertToGaeRequest convertToGaeRequest;
    private final ConvertToJcloudsResponse convertToJcloudsResponse;
    private final ListeningExecutorService ioExecutor;

    @Inject
    public AsyncGaeHttpCommandExecutorService(URLFetchService urlFetchService, HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, IOExceptionRetryHandler ioRetryHandler, DelegatingRetryHandler retryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, ConvertToGaeRequest convertToGaeRequest, ConvertToJcloudsResponse convertToJcloudsResponse) {
        super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire);
        this.ioExecutor = ioExecutor;
        this.urlFetchService = urlFetchService;
        this.convertToGaeRequest = convertToGaeRequest;
        this.convertToJcloudsResponse = convertToJcloudsResponse;
    }

    @VisibleForTesting
    protected HttpResponse convert(HTTPResponse gaeResponse) {
        return this.convertToJcloudsResponse.apply(gaeResponse);
    }

    @VisibleForTesting
    protected HTTPRequest convert(HttpRequest request) throws IOException {
        return this.convertToGaeRequest.apply(request);
    }

    protected void cleanup(HTTPRequest nativeRequest) {
    }

    protected HttpResponse invoke(HTTPRequest request) throws IOException {
        return this.convert(this.urlFetchService.fetch(request));
    }

    public HTTPRequest filterLogAndConvertRe(HttpRequest request) {
        for (HttpRequestFilter filter : request.getFilters()) {
            request = filter.filter(request);
        }
        HttpUtils.checkRequestHasContentLengthOrChunkedEncoding((HttpMessage)request, (String)("After filtering, the request has neither chunked encoding nor content length: " + request));
        this.logger.debug("Sending request %s: %s", new Object[]{request.hashCode(), request.getRequestLine()});
        HttpUtils.wirePayloadIfEnabled((Wire)this.wire, (HttpMessage)request);
        HTTPRequest nativeRequest = this.convertToGaeRequest.apply(request);
        this.utils.logRequest(this.headerLog, request, ">>");
        return nativeRequest;
    }

    public ListenableFuture<HttpResponse> submit(final HttpCommand command) {
        HTTPRequest nativeRequest = this.filterLogAndConvertRe(command.getCurrentRequest());
        ListenableFuture response = Futures.transform((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)this.urlFetchService.fetchAsync(nativeRequest)), (Function)this.convertToJcloudsResponse);
        return Futures.transform((ListenableFuture)response, (Function)new Function<HttpResponse, HttpResponse>(){

            public HttpResponse apply(HttpResponse response) {
                return AsyncGaeHttpCommandExecutorService.this.receiveResponse(command, response);
            }
        }, (Executor)this.ioExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse receiveResponse(HttpCommand command, HttpResponse response) {
        try {
            int statusCode;
            this.logger.debug("Receiving response %s: %s", new Object[]{command.getCurrentRequest().hashCode(), response.getStatusLine()});
            this.utils.logResponse(this.headerLog, response, "<<");
            if (response.getPayload() != null && this.wire.enabled()) {
                this.wire.input((PayloadEnclosing)response);
            }
            if ((statusCode = response.getStatusCode()) >= 300) {
                if (this.shouldContinue(command, response)) {
                    HttpResponse httpResponse = (HttpResponse)this.submit(command).get();
                    return httpResponse;
                }
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (Exception e) {
            IOException ioe = (IOException)Throwables2.getFirstThrowableOfType((Throwable)e, IOException.class);
            if (ioe != null && this.ioRetryHandler.shouldRetryRequest(command, ioe)) {
                try {
                    HttpResponse httpResponse = (HttpResponse)this.submit(command).get();
                    return httpResponse;
                }
                catch (Exception e1) {
                    command.setException(e1);
                    HttpResponse httpResponse = response;
                    return httpResponse;
                }
            }
            command.setException((Exception)new HttpResponseException(e.getMessage() + " connecting to " + command.getCurrentRequest().getRequestLine(), command, null, (Throwable)e));
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (command.getException() != null) {
                Throwables.propagate((Throwable)command.getException());
            }
        }
    }

    private boolean shouldContinue(HttpCommand command, HttpResponse response) {
        boolean shouldContinue = false;
        if (this.retryHandler.shouldRetryRequest(command, response)) {
            shouldContinue = true;
        } else {
            this.errorHandler.handleError(command, response);
        }
        return shouldContinue;
    }
}

