/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch;

import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.jsch.JschSshClient;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test
public class JschSshClientTest {
    protected JschSshClient ssh;

    @BeforeTest
    public void setupSsh() throws UnknownHostException {
        this.ssh = this.createClient(new Properties());
    }

    protected JschSshClient createClient() throws UnknownHostException {
        return this.createClient(new Properties());
    }

    protected JschSshClient createClient(final Properties props) throws UnknownHostException {
        Injector i = Guice.createInjector((Module[])new Module[]{this.module(), new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)props);
            }
        }, new SLF4JLoggingModule()});
        SshClient.Factory factory = (SshClient.Factory)i.getInstance(SshClient.Factory.class);
        JschSshClient ssh = (JschSshClient)JschSshClient.class.cast(factory.create(HostAndPort.fromParts((String)"localhost", (int)22), LoginCredentials.builder().user("username").password("password").build()));
        return ssh;
    }

    protected Module module() {
        return new JschSshClientModule();
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testPropateConvertsAuthException() {
        this.ssh.propagate((Exception)new JSchException("Auth fail"), "");
    }

    public void testExceptionClassesRetry() {
        assert (this.ssh.shouldRetry((Exception)new JSchException("io error", (Throwable)new IOException("socket closed"))));
        assert (this.ssh.shouldRetry((Exception)new JSchException("connect error", (Throwable)new ConnectException("problem"))));
        assert (this.ssh.shouldRetry((Exception)new IOException("channel %s is not open", new NullPointerException())));
        assert (this.ssh.shouldRetry((Exception)new IOException("channel %s is not open", new NullPointerException(null))));
    }

    public void testOnlyRetryAuthWhenSet() throws UnknownHostException {
        JschSshClient ssh1 = this.createClient();
        assert (!ssh1.shouldRetry((Exception)new AuthorizationException("problem", null)));
        ssh1.retryAuth = true;
        assert (ssh1.shouldRetry((Exception)new AuthorizationException("problem", null)));
    }

    public void testOnlyRetryAuthWhenSetViaProperties() throws UnknownHostException {
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retry-auth", "true");
        JschSshClient ssh1 = this.createClient(props);
        assert (ssh1.shouldRetry((Exception)new AuthorizationException("problem", null)));
    }

    public void testExceptionMessagesRetry() {
        assert (!this.ssh.shouldRetry((Exception)new NullPointerException("")));
        assert (!this.ssh.shouldRetry((Exception)new NullPointerException((String)null)));
        assert (this.ssh.shouldRetry((Exception)new JSchException("Session.connect: java.io.IOException: End of IO Stream Read")));
        assert (this.ssh.shouldRetry((Exception)new JSchException("Session.connect: invalid data")));
        assert (this.ssh.shouldRetry((Exception)new JSchException("Session.connect: java.net.SocketException: Connection reset")));
    }

    public void testDoNotRetryOnGeneralSftpError() {
        assert (!this.ssh.shouldRetry((Exception)new SftpException(4, new NullPointerException().toString())));
    }

    public void testCausalChainHasMessageContaining() {
        assert (this.ssh.causalChainHasMessageContaining((Exception)new JSchException("Session.connect: java.io.IOException: End of IO Stream Read")).apply((Object)" End of IO Stream Read"));
        assert (this.ssh.causalChainHasMessageContaining((Exception)new JSchException("Session.connect: invalid data")).apply((Object)" invalid data"));
        assert (this.ssh.causalChainHasMessageContaining((Exception)new JSchException("Session.connect: java.net.SocketException: Connection reset")).apply((Object)"java.net.Socket"));
        assert (!this.ssh.causalChainHasMessageContaining((Exception)new NullPointerException()).apply((Object)" End of IO Stream Read"));
    }

    public void testRetryOnToStringNpe() throws UnknownHostException {
        NullPointerException nex = new NullPointerException();
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retryable-messages", nex.toString());
        JschSshClient ssh1 = this.createClient(props);
        assert (ssh1.shouldRetry((Exception)new RuntimeException(nex)));
    }

    public void testRetryOnToStringCustom() throws UnknownHostException {
        ExceptionWithStrangeToString nex = new ExceptionWithStrangeToString();
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retryable-messages", "foo-bar");
        JschSshClient ssh1 = this.createClient(props);
        assert (ssh1.shouldRetry((Exception)new RuntimeException(nex)));
    }

    public void testRetryNotOnToStringCustomMismatch() throws UnknownHostException {
        ExceptionWithStrangeToString nex = new ExceptionWithStrangeToString();
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retryable-messages", "foo-baR");
        JschSshClient ssh1 = this.createClient(props);
        assert (!ssh1.shouldRetry((Exception)new RuntimeException(nex)));
    }

    private static class ExceptionWithStrangeToString
    extends RuntimeException {
        private static final String MESSAGE = "foo-bar-exception-tostring";

        private ExceptionWithStrangeToString() {
        }

        @Override
        public String toString() {
            return MESSAGE;
        }
    }
}

