/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj;

import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import java.util.logging.Level;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import org.easymock.EasyMock;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.BufferLogger;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.SSHClientConnection;
import org.jclouds.sshj.SshjSshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test
public class SshjSshClientTest {
    protected SshjSshClient ssh;

    @BeforeTest
    public void setupSsh() {
        this.ssh = this.createClient();
    }

    protected SshjSshClient createClient() {
        return this.createClient(new Properties());
    }

    protected SshjSshClient createClient(final Properties props) {
        Injector i = Guice.createInjector((Module[])new Module[]{this.module(), new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)props);
            }
        }, new SLF4JLoggingModule()});
        SshClient.Factory factory = (SshClient.Factory)i.getInstance(SshClient.Factory.class);
        SshjSshClient ssh = (SshjSshClient)SshjSshClient.class.cast(factory.create(HostAndPort.fromParts((String)"localhost", (int)22), LoginCredentials.builder().user("username").password("password").build()));
        return ssh;
    }

    protected Module module() {
        return new SshjSshClientModule();
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testPropateConvertsAuthException() {
        this.ssh.propagate((Exception)new UserAuthException(""), "");
    }

    public void testExceptionClassesRetry() {
        assert (this.ssh.shouldRetry((Exception)new ConnectionException("Read timed out", (Throwable)new SSHException("Read timed out", (Throwable)new SocketTimeoutException("Read timed out")))));
        assert (this.ssh.shouldRetry((Exception)new SFTPException("Failure!")));
        assert (this.ssh.shouldRetry((Exception)new SocketTimeoutException("connect timed out")));
        assert (this.ssh.shouldRetry((Exception)new TransportException("socket closed")));
        assert (this.ssh.shouldRetry((Exception)new ConnectionException("problem")));
        assert (this.ssh.shouldRetry((Exception)new ConnectException("Connection refused")));
        assert (!this.ssh.shouldRetry((Exception)new IOException("channel %s is not open", new NullPointerException())));
    }

    public void testOnlyRetryAuthWhenSet() {
        SshjSshClient ssh1 = this.createClient();
        assert (!ssh1.shouldRetry((Exception)new AuthorizationException("problem", null)));
        assert (!ssh1.shouldRetry((Exception)new UserAuthException("problem", null)));
        ssh1.retryAuth = true;
        assert (ssh1.shouldRetry((Exception)new AuthorizationException("problem", null)));
        assert (ssh1.shouldRetry((Exception)new UserAuthException("problem", null)));
    }

    public void testOnlyRetryAuthWhenSetViaProperties() {
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retry-auth", "true");
        SshjSshClient ssh1 = this.createClient(props);
        assert (ssh1.shouldRetry((Exception)new AuthorizationException("problem", null)));
        assert (ssh1.shouldRetry((Exception)new UserAuthException("problem", null)));
    }

    public void testExceptionMessagesRetry() {
        assert (!this.ssh.shouldRetry((Exception)new SSHException("")));
        assert (!this.ssh.shouldRetry((Exception)new NullPointerException((String)null)));
    }

    public void testCausalChainHasMessageContaining() {
        assert (this.ssh.causalChainHasMessageContaining((Exception)new SSHException("Session.connect: java.io.IOException: End of IO Stream Read")).apply((Object)" End of IO Stream Read"));
        assert (this.ssh.causalChainHasMessageContaining((Exception)new SSHException("Session.connect: java.net.SocketException: Connection reset")).apply((Object)"java.net.Socket"));
        assert (!this.ssh.causalChainHasMessageContaining((Exception)new NullPointerException()).apply((Object)" End of IO Stream Read"));
    }

    public void testRetryOnToStringNpe() {
        NullPointerException nex = new NullPointerException();
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retryable-messages", nex.toString());
        SshjSshClient ssh1 = this.createClient(props);
        assert (ssh1.shouldRetry((Exception)new RuntimeException(nex)));
    }

    public void testRetryOnToStringCustom() {
        ExceptionWithStrangeToString nex = new ExceptionWithStrangeToString();
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retryable-messages", "foo-bar");
        SshjSshClient ssh1 = this.createClient(props);
        assert (ssh1.shouldRetry((Exception)new RuntimeException(nex)));
    }

    public void testDontThrowIOExceptionOnClear() throws Exception {
        SshjSshClient ssh1 = this.createClient();
        SSHClient ssh = (SSHClient)EasyMock.createMock(SSHClient.class);
        EasyMock.expect((Object)ssh.isConnected()).andReturn((Object)true);
        ssh.disconnect();
        EasyMock.expectLastCall().andThrow((Throwable)new ConnectionException("disconnected"));
        EasyMock.replay((Object[])new Object[]{ssh});
        ssh1.sshClientConnection.ssh = ssh;
        ssh1.sshClientConnection.clear();
        EasyMock.verify((Object[])new Object[]{ssh});
    }

    public void testRetryNotOnToStringCustomMismatch() {
        ExceptionWithStrangeToString nex = new ExceptionWithStrangeToString();
        Properties props = new Properties();
        props.setProperty("jclouds.ssh.retryable-messages", "foo-baR");
        SshjSshClient ssh1 = this.createClient(props);
        assert (!ssh1.shouldRetry((Exception)new RuntimeException(nex)));
    }

    public void testRetriesLoggedAtInfoWithCount() throws Exception {
        SSHClientConnection mockConnection = (SSHClientConnection)EasyMock.createMock(SSHClientConnection.class);
        SSHClient mockClient = (SSHClient)EasyMock.createMock(SSHClient.class);
        mockConnection.clear();
        EasyMock.expectLastCall();
        mockConnection.create();
        EasyMock.expectLastCall().andThrow((Throwable)new ConnectionException("test1"));
        mockConnection.clear();
        EasyMock.expectLastCall();
        mockConnection.clear();
        EasyMock.expectLastCall();
        mockConnection.create();
        EasyMock.expectLastCall().andReturn((Object)mockClient);
        EasyMock.replay((Object[])new Object[]{mockConnection});
        EasyMock.replay((Object[])new Object[]{mockClient});
        this.ssh.sshClientConnection = mockConnection;
        BufferLogger logcheck = new BufferLogger(this.ssh.getClass().getCanonicalName());
        this.ssh.logger = logcheck;
        logcheck.setLevel(Level.INFO);
        this.ssh.connect();
        Assert.assertEquals((Object)this.ssh.sshClientConnection, (Object)mockConnection);
        EasyMock.verify((Object[])new Object[]{mockConnection});
        EasyMock.verify((Object[])new Object[]{mockClient});
        BufferLogger.Record r = logcheck.assertLogContains("attempt 1 of 5");
        logcheck.assertLogDoesntContain("attempt 2 of 5");
        Assert.assertEquals((Object)Level.INFO, (Object)r.getLevel());
    }

    private static class ExceptionWithStrangeToString
    extends RuntimeException {
        private static final String MESSAGE = "foo-bar-exception-tostring";

        private ExceptionWithStrangeToString() {
        }

        @Override
        public String toString() {
            return MESSAGE;
        }
    }
}

