/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="blobstore.BlobStoreContextFactoryTest")
public class BlobStoreContextFactoryTest {
    public void test() throws IOException {
        URI blobStore = URI.create("provider://identity:key@container/path");
        Assert.assertEquals((String)blobStore.getScheme(), (String)"provider");
        Iterator identityKey = Splitter.on((String)":").split((CharSequence)Preconditions.checkNotNull((Object)blobStore.getUserInfo(), (Object)"userInfo")).iterator();
        Assert.assertEquals((String)((String)identityKey.next()), (String)"identity");
        Assert.assertEquals((String)((String)identityKey.next()), (String)"key");
        Assert.assertEquals((String)blobStore.getHost(), (String)"container");
        Assert.assertEquals((String)blobStore.getPath(), (String)"/path");
    }

    public void testNoPassword() throws IOException {
        URI blobStore = URI.create("provider://identity@container/path");
        Assert.assertEquals((String)blobStore.getScheme(), (String)"provider");
        Iterator identityKey = Splitter.on((String)":").split((CharSequence)Preconditions.checkNotNull((Object)blobStore.getUserInfo(), (Object)"userInfo")).iterator();
        Assert.assertEquals((String)((String)identityKey.next()), (String)"identity");
        Assert.assertEquals((String)blobStore.getHost(), (String)"container");
        Assert.assertEquals((String)blobStore.getPath(), (String)"/path");
    }
}

