/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.InputStreamMap;
import org.jclouds.blobstore.integration.internal.BaseMapIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseInputStreamMapIntegrationTest
extends BaseMapIntegrationTest<InputStream> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testValues() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putAll(this.fiveInputs);
            this.assertConsistencyAwareMapSize(map, 5);
            Collection values = map.values();
            Assert.assertEquals((int)values.size(), (int)5);
            LinkedHashSet valuesAsString = Sets.newLinkedHashSet();
            for (InputStream stream : values) {
                valuesAsString.add(Strings2.toStringAndClose((InputStream)stream));
            }
            valuesAsString.removeAll(this.fiveStrings.values());
            assert (valuesAsString.size() == 0) : valuesAsString.size() + ": " + values + ": " + valuesAsString;
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutMoreThanSingleListing() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            LinkedHashSet keySet = Sets.newLinkedHashSet();
            for (int i = 0; i < this.maxResultsForTestListings() + 1; ++i) {
                keySet.add(i + "");
            }
            HashMap newMap = Maps.newHashMap();
            for (String key : keySet) {
                newMap.put(key, key);
            }
            map.putAllStrings((Map)newMap);
            newMap.clear();
            this.assertConsistencyAwareMapSize(map, this.maxResultsForTestListings() + 1);
            this.assertConsistencyAwareKeySetEquals(map, keySet);
            map.clear();
            this.assertConsistencyAwareMapSize(map, 0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testRemove() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            this.putStringWithMD5((Map<String, InputStream>)map, "one", "two");
            InputStream old = (InputStream)map.remove("one");
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)old), (String)"two");
            this.assertConsistencyAwareKeySize(map, 0);
            old = (InputStream)map.remove("one");
            assert (old == null);
            old = (InputStream)map.get("one");
            assert (old == null);
            this.assertConsistencyAwareKeySize(map, 0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testEntrySet() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putAllStrings(this.fiveStrings);
            this.assertConsistencyAwareKeySize(map, 5);
            Set entries = map.entrySet();
            Assert.assertEquals((int)entries.size(), (int)5);
            for (Map.Entry entry : entries) {
                Assert.assertEquals((String)((String)this.fiveStrings.get(entry.getKey())), (String)Strings2.toStringAndClose((InputStream)((InputStream)entry.getValue())));
                entry.setValue(Strings2.toInputStream((String)""));
            }
            this.assertConsistencyAwareMapSize(map, 5);
            for (Map.Entry entry : map.entrySet()) {
                Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((InputStream)Preconditions.checkNotNull(entry.getValue(), entry.getKey()))), (String)"");
            }
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainsStringValue() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putString("one", String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"));
            this.assertConsistencyAwareContainsValue(map, this.fiveStrings.get("one"));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainsFileValue() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putString("one", String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"));
            this.assertConsistencyAwareContainsValue(map, this.fiveFiles.get("one"));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainsInputStreamValue() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putString("one", String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"));
            this.assertConsistencyAwareContainsValue(map, this.fiveInputs.get("one"));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainsBytesValue() throws InterruptedException, ExecutionException, TimeoutException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putString("one", String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"));
            this.assertConsistencyAwareContainsValue(map, this.fiveBytes.get("one"));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testPutAll() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putAll(this.fiveInputs);
            this.assertConsistencyAwareMapSize(map, 5);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)new TreeSet<String>(this.fiveInputs.keySet()));
            this.fourLeftRemovingOne(map);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutAllBytes() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putAllBytes(this.fiveBytes);
            this.assertConsistencyAwareMapSize(map, 5);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)new TreeSet<String>(this.fiveBytes.keySet()));
            this.fourLeftRemovingOne(map);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutAllFiles() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putAllFiles(this.fiveFiles);
            this.assertConsistencyAwareMapSize(map, 5);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)new TreeSet<String>(this.fiveFiles.keySet()));
            this.fourLeftRemovingOne(map);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutAllStrings() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            map.putAllStrings(this.fiveStrings);
            this.assertConsistencyAwareMapSize(map, 5);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)new TreeSet<String>(this.fiveStrings.keySet()));
            this.fourLeftRemovingOne(map);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutString() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            InputStream old = map.putString("one", (String)this.fiveStrings.get("one"));
            this.getOneReturnsAppleAndOldValueIsNull((Map<String, InputStream>)map, old);
            InputStream apple = map.putString("one", (String)this.fiveStrings.get("two"));
            this.getOneReturnsBearAndOldValueIsApple((Map<String, InputStream>)map, apple);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    void getOneReturnsAppleAndOldValueIsNull(Map<String, InputStream> map, InputStream old) throws IOException, InterruptedException {
        assert (old == null);
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)map.get("one")), (String)String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"));
        this.assertConsistencyAwareMapSize(map, 1);
    }

    void getOneReturnsBearAndOldValueIsApple(Map<String, InputStream> map, InputStream oldValue) throws IOException, InterruptedException {
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)map.get("one")), (String)String.format("<apples><apple name=\"%s\"></apple> </apples>", "bear"));
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)oldValue), (String)String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"));
        this.assertConsistencyAwareMapSize(map, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutFile() throws IOException, InterruptedException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            InputStream old = map.putFile("one", (File)this.fiveFiles.get("one"));
            this.getOneReturnsAppleAndOldValueIsNull((Map<String, InputStream>)map, old);
            InputStream apple = map.putFile("one", (File)this.fiveFiles.get("two"));
            this.getOneReturnsBearAndOldValueIsApple((Map<String, InputStream>)map, apple);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutBytes() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            InputStream old = map.putBytes("one", (byte[])this.fiveBytes.get("one"));
            this.getOneReturnsAppleAndOldValueIsNull((Map<String, InputStream>)map, old);
            InputStream apple = map.putBytes("one", (byte[])this.fiveBytes.get("two"));
            this.getOneReturnsBearAndOldValueIsApple((Map<String, InputStream>)map, apple);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testPut() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        try {
            InputStreamMap map = this.createMap((BlobStoreContext)this.view, containerName);
            InputStream old = (InputStream)map.put("one", this.fiveInputs.get("one"));
            this.getOneReturnsAppleAndOldValueIsNull((Map<String, InputStream>)map, old);
            InputStream apple = (InputStream)map.put("one", this.fiveInputs.get("two"));
            this.getOneReturnsBearAndOldValueIsApple((Map<String, InputStream>)map, apple);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    @Override
    protected void putStringWithMD5(Map<String, InputStream> map, String key, String value) throws InterruptedException {
        ((InputStreamMap)map).putString(key, value);
    }

    protected int maxResultsForTestListings() {
        return 100;
    }

    protected InputStreamMap createMap(BlobStoreContext context, String bucket) {
        return this.createMap(context, bucket, ListContainerOptions.Builder.maxResults((int)this.maxResultsForTestListings()));
    }

    protected InputStreamMap createMap(BlobStoreContext context, String bucket, ListContainerOptions options) {
        return context.createInputStreamMap(bucket, options);
    }
}

