/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseBlobSignerExpectTest
extends BaseRestClientExpectTest<BlobStore> {
    protected String container = "container";
    protected String name = "name";
    protected String text = "fooooooooooooooooooooooo";
    protected GetOptions options = GetOptions.Builder.range((long)0L, (long)1L);

    protected Map<HttpRequest, HttpResponse> init() {
        return ImmutableMap.of();
    }

    @Test
    public void testSignGetBlob() {
        BlobStore getBlob = (BlobStore)this.requestsSendResponses(this.init());
        Assert.assertEquals((Object)getBlob.getContext().getSigner().signGetBlob(this.container, this.name), (Object)this.getBlob());
    }

    protected abstract HttpRequest getBlob();

    @Test
    public void testSignGetBlobWithTime() {
        BlobStore getBlobWithTime = (BlobStore)this.requestsSendResponses(this.init());
        HttpRequest compare = this.getBlobWithTime();
        Assert.assertEquals((Object)getBlobWithTime.getContext().getSigner().signGetBlob(this.container, this.name, 3L), (Object)compare);
    }

    protected abstract HttpRequest getBlobWithTime();

    @Test
    public void testSignGetBlobWithOptions() {
        BlobStore getBlobWithOptions = (BlobStore)this.requestsSendResponses(this.init());
        Assert.assertEquals((Object)getBlobWithOptions.getContext().getSigner().signGetBlob(this.container, this.name, this.options), (Object)this.getBlobWithOptions());
    }

    protected abstract HttpRequest getBlobWithOptions();

    @Test
    public void testSignRemoveBlob() {
        BlobStore removeBlob = (BlobStore)this.requestsSendResponses(this.init());
        Assert.assertEquals((Object)removeBlob.getContext().getSigner().signRemoveBlob(this.container, this.name), (Object)this.removeBlob());
    }

    @Test
    public void testSignPutBlob() throws Exception {
        BlobStore signPutBlob = (BlobStore)this.requestsSendResponses(this.init());
        Blob blob = signPutBlob.blobBuilder("name").forSigning().contentLength(2L).contentMD5(new byte[]{0, 2, 4, 8}).contentType("text/plain").expires(new Date(1000L)).build();
        HttpRequest compare = this.putBlob();
        compare.setPayload(blob.getPayload());
        Assert.assertEquals((Object)signPutBlob.getContext().getSigner().signPutBlob(this.container, blob), (Object)compare);
    }

    protected abstract HttpRequest putBlob();

    @Test
    public void testSignPutBlobWithTime() throws Exception {
        BlobStore signPutBloblWithTime = (BlobStore)this.requestsSendResponses(this.init());
        Blob blob = signPutBloblWithTime.blobBuilder(this.name).payload(this.text).contentType("text/plain").build();
        HttpRequest compare = this.putBlobWithTime();
        compare.setPayload(blob.getPayload());
        Assert.assertEquals((Object)signPutBloblWithTime.getContext().getSigner().signPutBlob(this.container, blob, 3L), (Object)compare);
    }

    protected abstract HttpRequest putBlobWithTime();

    protected abstract HttpRequest removeBlob();

    public BlobStore createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (BlobStore)this.createInjector(fn, module, props).getInstance(BlobStore.class);
    }
}

