/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim.xml;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.cim.xml.VirtualSystemSettingDataHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.VirtualSystem;
import org.jclouds.ovf.internal.BaseVirtualSystem;
import org.jclouds.ovf.xml.VirtualSystemHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VirtualSystemSettingDataHandlerTest")
public class VirtualSystemSettingDataHandlerTest
extends BaseHandlerTest {
    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/virtualsystem-hosting.xml");
        VirtualSystemSettingData result = (VirtualSystemSettingData)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VirtualSystemSettingDataHandler.class)).parse(is);
        VirtualSystemSettingData expects = VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("SimpleVM").virtualSystemType("vmx-04").build();
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testVCloud1_0() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/virtualsystem.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VirtualSystem result = (VirtualSystem)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VirtualSystemHandler.class)).parse(is);
        VirtualSystemSettingDataHandlerTest.checkVirtualSystem(result);
    }

    @Test(enabled=false)
    public static <T extends BaseVirtualSystem<T>> void checkVirtualSystem(BaseVirtualSystem<T> result) {
        Assert.assertEquals((String)result.getId(), (String)"Ubuntu1004");
        Assert.assertEquals((String)result.getName(), (String)"Ubuntu1004");
        Assert.assertEquals((String)result.getInfo(), (String)"A virtual machine:");
        VirtualSystemSettingDataHandlerTest.checkHardware((VirtualHardwareSection)Iterables.get((Iterable)result.getVirtualHardwareSections(), (int)0));
        VirtualSystemSettingDataHandlerTest.checkOs(result.getOperatingSystemSection());
    }

    @Test(enabled=false)
    public static void checkHardware(VirtualHardwareSection result) {
        Assert.assertEquals((Object)result.getSystem(), (Object)VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("Ubuntu1004").virtualSystemType("vmx-07").build());
        Assert.assertEquals((String)result.getInfo(), (String)"Virtual hardware requirements");
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)0)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("1").elementName("Network adapter 0").description("PCNet32 ethernet adapter").resourceType(ResourceAllocationSettingData.ResourceType.ETHERNET_ADAPTER).resourceSubType("PCNet32").address("00:50:56:8c:00:13").automaticAllocation(Boolean.valueOf(true)).connection("vAppNet-vApp Internal").addressOnParent("0").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)1)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("2").elementName("SCSI Controller 0").description("SCSI Controller").resourceType(ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA).resourceSubType("lsilogic").address("0").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)2)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("2000").elementName("Hard disk 1").description("Hard disk").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).addressOnParent("0").parent("2").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)3)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("3").elementName("IDE Controller 0").description("IDE Controller").resourceType(ResourceAllocationSettingData.ResourceType.IDE_CONTROLLER).address("0").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)4)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("3002").elementName("CD/DVD Drive 1").description("CD/DVD Drive").resourceType(ResourceAllocationSettingData.ResourceType.CD_DRIVE).addressOnParent("0").parent("3").automaticAllocation(Boolean.valueOf(false)).build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)5)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("8000").elementName("Floppy Drive 1").description("Floppy Drive").resourceType(ResourceAllocationSettingData.ResourceType.FLOPPY_DRIVE).addressOnParent("0").automaticAllocation(Boolean.valueOf(false)).build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)6)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("4").elementName("1 virtual CPU(s)").description("Number of Virtual CPUs").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(1L)).allocationUnits("hertz * 10^6").reservation(Long.valueOf(0L)).weight(Integer.valueOf(0)).build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)7)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("5").elementName("512 MB of memory").description("Memory Size").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(512L)).allocationUnits("byte * 2^20").reservation(Long.valueOf(0L)).weight(Integer.valueOf(0)).build().toString());
    }

    @Test(enabled=false)
    public static void checkOs(OperatingSystemSection result) {
        Assert.assertEquals((String)result.getDescription(), (String)"Ubuntu Linux (64-bit)");
        Assert.assertEquals((Object)result.getId(), (Object)94);
        Assert.assertEquals((String)result.getInfo(), (String)"Specifies the operating system installed");
    }
}

