/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import java.net.URI;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.java.InstallJDK;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

public class JettyStatements {
    public static final URI JETTY_URL = URI.create(System.getProperty("test.jetty-url", "http://archive.eclipse.org/jetty/8.1.8.v20121106/dist/jetty-distribution-8.1.8.v20121106.tar.gz"));
    public static final String JETTY_HOME = "/usr/local/jetty";
    public static final int port = 8080;

    public static Statement version() {
        return Statements.exec((String)String.format("head -1 %s/VERSION.txt | cut -f1 -d ' '", JETTY_HOME));
    }

    public static Statement install() {
        return new StatementList(new Statement[]{AdminAccess.builder().adminUsername("web").build(), InstallJDK.fromOpenJDK(), JettyStatements.authorizePortInIpTables(), Statements.extractTargzAndFlattenIntoDirectory((URI)JETTY_URL, (String)JETTY_HOME), Statements.exec((String)"chown -R web /usr/local/jetty")});
    }

    private static Statement authorizePortInIpTables() {
        return new StatementList(new Statement[]{Statements.exec((String)"iptables -I INPUT 1 -p tcp --dport 8080 -j ACCEPT"), Statements.exec((String)"iptables-save")});
    }

    public static Statement start() {
        return new StatementList(new Statement[]{Statements.literal((String)"cd /usr/local/jetty"), Statements.literal((String)"nohup java -jar start.jar jetty.port=8080 > start.out 2> start.err < /dev/null &"), Statements.literal((String)"test $? && sleep 1")});
    }

    public static Statement stop() {
        return new StatementList(new Statement[]{Statements.literal((String)"cd /usr/local/jetty"), Statements.literal((String)"./bin/jetty.sh stop")});
    }
}

