/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.easymock.EasyMock;
import org.jclouds.compute.callables.BlockUntilInitScriptStatusIsZeroThenReturnOutput;
import org.jclouds.compute.callables.SudoAwareInitManager;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.scriptbuilder.InitScript;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="BlockUntilInitScriptStatusIsZeroThenReturnOutputTest")
public class BlockUntilInitScriptStatusIsZeroThenReturnOutputTest {
    EventBus eventBus = new EventBus();

    public void testloopUntilTrueOrThrowCancellationExceptionReturnsWhenPredicateIsTrue() {
        AbstractFuture<ExecResponse> future = new AbstractFuture<ExecResponse>(){

            public boolean isCancelled() {
                return false;
            }
        };
        Predicate pred = BlockUntilInitScriptStatusIsZeroThenReturnOutput.loopUntilTrueOrThrowCancellationException((Predicate)Predicates.alwaysTrue(), (long)1L, (long)1L, (AbstractFuture)future);
        Assert.assertEquals((boolean)pred.apply((Object)"foo"), (boolean)true);
    }

    public void testloopUntilTrueOrThrowCancellationExceptionReturnsWhenPredicateIsTrueSecondTimeWhileNotCancelled() {
        AbstractFuture<ExecResponse> future = new AbstractFuture<ExecResponse>(){

            public boolean isCancelled() {
                return false;
            }
        };
        Predicate<String> predicate = new Predicate<String>(){
            AtomicBoolean bool = new AtomicBoolean();

            public boolean apply(String input) {
                return this.bool.getAndSet(true);
            }
        };
        Predicate pred = BlockUntilInitScriptStatusIsZeroThenReturnOutput.loopUntilTrueOrThrowCancellationException((Predicate)predicate, (long)1L, (long)1L, (AbstractFuture)future);
        Assert.assertEquals((boolean)pred.apply((Object)"foo"), (boolean)true);
    }

    public void testloopUntilTrueOrThrowCancellationExceptionSkipsAndReturnsFalseOnCancelled() {
        AbstractFuture<ExecResponse> future = new AbstractFuture<ExecResponse>(){

            public boolean isCancelled() {
                return true;
            }
        };
        Predicate pred = BlockUntilInitScriptStatusIsZeroThenReturnOutput.loopUntilTrueOrThrowCancellationException((Predicate)Predicates.alwaysFalse(), (long)1L, (long)1L, (AbstractFuture)future);
        Assert.assertEquals((boolean)pred.apply((Object)"foo"), (boolean)false);
    }

    public void testExitStatusOfCommandGreaterThanZeroTrueWhen1() {
        SudoAwareInitManager commandRunner = (SudoAwareInitManager)EasyMock.createMockBuilder(SudoAwareInitManager.class).addMockedMethod("runAction").createStrictMock();
        EasyMock.expect((Object)commandRunner.runAction("status")).andReturn((Object)new ExecResponse("", "", 1));
        EasyMock.replay((Object[])new Object[]{commandRunner});
        BlockUntilInitScriptStatusIsZeroThenReturnOutput.ExitStatusOfCommandGreaterThanZero pred = new BlockUntilInitScriptStatusIsZeroThenReturnOutput.ExitStatusOfCommandGreaterThanZero(commandRunner);
        Assert.assertEquals((boolean)pred.apply((Object)"status"), (boolean)true);
        EasyMock.verify((Object[])new Object[]{commandRunner});
    }

    public void testExitStatusOfCommandGreaterThanZeroFalseWhen0() {
        SudoAwareInitManager commandRunner = (SudoAwareInitManager)EasyMock.createMockBuilder(SudoAwareInitManager.class).addMockedMethod("runAction").createStrictMock();
        EasyMock.expect((Object)commandRunner.runAction("status")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.replay((Object[])new Object[]{commandRunner});
        BlockUntilInitScriptStatusIsZeroThenReturnOutput.ExitStatusOfCommandGreaterThanZero pred = new BlockUntilInitScriptStatusIsZeroThenReturnOutput.ExitStatusOfCommandGreaterThanZero(commandRunner);
        Assert.assertEquals((boolean)pred.apply((Object)"status"), (boolean)false);
        EasyMock.verify((Object[])new Object[]{commandRunner});
    }

    public void testExitStatusZeroReturnsExecResponse() throws InterruptedException, ExecutionException {
        ListeningExecutorService userExecutor = MoreExecutors.sameThreadExecutor();
        Predicate notRunningAnymore = Predicates.alwaysTrue();
        SudoAwareInitManager commandRunner = (SudoAwareInitManager)EasyMock.createMockBuilder(SudoAwareInitManager.class).addMockedMethod("runAction").addMockedMethod("getStatement").addMockedMethod("getNode").addMockedMethod("toString").createStrictMock();
        InitScript initScript = (InitScript)EasyMock.createMockBuilder(InitScript.class).addMockedMethod("getInstanceName").createStrictMock();
        EasyMock.expect((Object)commandRunner.runAction("stdout")).andReturn((Object)new ExecResponse("stdout", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("stderr")).andReturn((Object)new ExecResponse("stderr", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("exitstatus")).andReturn((Object)new ExecResponse("444\n", "", 0));
        this.toStringAndEventBusExpectations(commandRunner, initScript);
        EasyMock.replay((Object[])new Object[]{commandRunner, initScript});
        BlockUntilInitScriptStatusIsZeroThenReturnOutput future = new BlockUntilInitScriptStatusIsZeroThenReturnOutput(userExecutor, this.eventBus, notRunningAnymore, commandRunner);
        future.run();
        Assert.assertEquals((Object)future.get(), (Object)new ExecResponse("stdout", "stderr", 444));
        EasyMock.verify((Object[])new Object[]{commandRunner, initScript});
    }

    public void testFirstExitStatusOneButSecondExitStatusZeroReturnsExecResponse() throws InterruptedException, ExecutionException {
        ListeningExecutorService userExecutor = MoreExecutors.sameThreadExecutor();
        Predicate notRunningAnymore = Predicates.alwaysTrue();
        SudoAwareInitManager commandRunner = (SudoAwareInitManager)EasyMock.createMockBuilder(SudoAwareInitManager.class).addMockedMethod("runAction").addMockedMethod("getStatement").addMockedMethod("getNode").addMockedMethod("toString").createStrictMock();
        InitScript initScript = (InitScript)EasyMock.createMockBuilder(InitScript.class).addMockedMethod("getInstanceName").createStrictMock();
        EasyMock.expect((Object)commandRunner.runAction("stdout")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("stderr")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("exitstatus")).andReturn((Object)new ExecResponse("", "", 1));
        EasyMock.expect((Object)commandRunner.runAction("stdout")).andReturn((Object)new ExecResponse("stdout", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("stderr")).andReturn((Object)new ExecResponse("stderr", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("exitstatus")).andReturn((Object)new ExecResponse("444\n", "", 0));
        this.toStringAndEventBusExpectations(commandRunner, initScript);
        EasyMock.replay((Object[])new Object[]{commandRunner, initScript});
        BlockUntilInitScriptStatusIsZeroThenReturnOutput future = new BlockUntilInitScriptStatusIsZeroThenReturnOutput(userExecutor, this.eventBus, notRunningAnymore, commandRunner);
        future.run();
        Assert.assertEquals((Object)future.get(), (Object)new ExecResponse("stdout", "stderr", 444));
        EasyMock.verify((Object[])new Object[]{commandRunner, initScript});
    }

    public void testCancelInterruptStopsCommand() throws InterruptedException, ExecutionException {
        ListeningExecutorService userExecutor = MoreExecutors.sameThreadExecutor();
        Predicate notRunningAnymore = Predicates.alwaysTrue();
        SudoAwareInitManager commandRunner = (SudoAwareInitManager)EasyMock.createMockBuilder(SudoAwareInitManager.class).addMockedMethod("refreshAndRunAction").addMockedMethod("runAction").addMockedMethod("getStatement").addMockedMethod("getNode").addMockedMethod("toString").createStrictMock();
        InitScript initScript = (InitScript)EasyMock.createMockBuilder(InitScript.class).addMockedMethod("getInstanceName").createStrictMock();
        EasyMock.expect((Object)commandRunner.getStatement()).andReturn((Object)initScript);
        EasyMock.expect((Object)initScript.getInstanceName()).andReturn((Object)"init-script");
        EasyMock.expect((Object)commandRunner.refreshAndRunAction("stop")).andReturn((Object)new ExecResponse("stdout", "", 0));
        EasyMock.expect((Object)commandRunner.getStatement()).andReturn((Object)initScript);
        EasyMock.expect((Object)initScript.getInstanceName()).andReturn((Object)"init-script");
        EasyMock.expect((Object)commandRunner.getNode()).andReturn((Object)new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build()).atLeastOnce();
        EasyMock.expect((Object)commandRunner.getStatement()).andReturn((Object)initScript);
        EasyMock.expect((Object)commandRunner.getNode()).andReturn((Object)new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{commandRunner, initScript});
        BlockUntilInitScriptStatusIsZeroThenReturnOutput future = new BlockUntilInitScriptStatusIsZeroThenReturnOutput(userExecutor, this.eventBus, notRunningAnymore, commandRunner);
        future.cancel(true);
        try {
            future.get();
            Assert.fail();
        }
        catch (CancellationException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{commandRunner, initScript});
    }

    public void testCancelDontInterruptLeavesCommandRunningAndReturnsLastStatus() throws InterruptedException, ExecutionException {
        ListeningExecutorService userExecutor = MoreExecutors.sameThreadExecutor();
        Predicate notRunningAnymore = Predicates.alwaysTrue();
        SudoAwareInitManager commandRunner = (SudoAwareInitManager)EasyMock.createMockBuilder(SudoAwareInitManager.class).addMockedMethod("runAction").addMockedMethod("getStatement").addMockedMethod("getNode").addMockedMethod("toString").createStrictMock();
        InitScript initScript = (InitScript)EasyMock.createMockBuilder(InitScript.class).addMockedMethod("getInstanceName").createStrictMock();
        EasyMock.expect((Object)commandRunner.runAction("stdout")).andReturn((Object)new ExecResponse("stillrunning", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("stderr")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)commandRunner.runAction("exitstatus")).andReturn((Object)new ExecResponse("", "", 1));
        this.toStringAndEventBusExpectations(commandRunner, initScript);
        EasyMock.replay((Object[])new Object[]{commandRunner, initScript});
        BlockUntilInitScriptStatusIsZeroThenReturnOutput future = new BlockUntilInitScriptStatusIsZeroThenReturnOutput(userExecutor, this.eventBus, notRunningAnymore, commandRunner);
        future.cancel(false);
        future.run();
        try {
            future.get();
            Assert.fail();
        }
        catch (CancellationException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{commandRunner, initScript});
    }

    private void toStringAndEventBusExpectations(SudoAwareInitManager commandRunner, InitScript initScript) {
        this.toStringExpectations(commandRunner, initScript);
        EasyMock.expect((Object)commandRunner.getStatement()).andReturn((Object)initScript);
        EasyMock.expect((Object)commandRunner.getNode()).andReturn((Object)new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build());
    }

    private void toStringExpectations(SudoAwareInitManager commandRunner, InitScript initScript) {
        EasyMock.expect((Object)commandRunner.getStatement()).andReturn((Object)initScript);
        EasyMock.expect((Object)initScript.getInstanceName()).andReturn((Object)"init-script");
    }
}

