/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="InitScriptConfigurationForTasksTest")
public class InitScriptConfigurationForTasksTest {
    public void testDefaults() {
        InitScriptConfigurationForTasks config = InitScriptConfigurationForTasks.create();
        Assert.assertEquals((String)config.getAnonymousTaskSuffixSupplier().toString(), (String)"currentTimeMillis()");
        Assert.assertEquals((String)config.getBasedir(), (String)"/tmp");
        Assert.assertEquals((String)config.getInitScriptPattern(), (String)"/tmp/init-%s");
    }

    public void testPatternUpdatesBasedir() {
        InitScriptConfigurationForTasks config = InitScriptConfigurationForTasks.create();
        config.initScriptPattern("/var/foo-init-%s");
        Assert.assertEquals((String)config.getBasedir(), (String)String.format("%svar", File.separator));
        Assert.assertEquals((String)config.getInitScriptPattern(), (String)"/var/foo-init-%s");
    }

    public void testPatternUpdatesBasedirGuice() {
        InitScriptConfigurationForTasks config = (InitScriptConfigurationForTasks)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.compute.init-script-pattern")).to("/var/foo-init-%s");
            }
        }}).getInstance(InitScriptConfigurationForTasks.class);
        config.initScriptPattern("/var/foo-init-%s");
        Assert.assertEquals((String)config.getBasedir(), (String)String.format("%svar", File.separator));
        Assert.assertEquals((String)config.getInitScriptPattern(), (String)"/var/foo-init-%s");
    }

    public void testCurrentTimeSupplier() throws InterruptedException {
        InitScriptConfigurationForTasks config = InitScriptConfigurationForTasks.create();
        long time1 = Long.parseLong((String)config.getAnonymousTaskSuffixSupplier().get());
        assert (time1 <= System.currentTimeMillis());
        Thread.sleep(10L);
        long time2 = Long.parseLong((String)config.getAnonymousTaskSuffixSupplier().get());
        assert (time2 <= System.currentTimeMillis());
        assert (time2 > time1);
    }

    public void testIncrementingTimeSupplier() throws InterruptedException {
        InitScriptConfigurationForTasks config = InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames();
        Assert.assertEquals((String)((String)config.getAnonymousTaskSuffixSupplier().get()), (String)"0");
        Assert.assertEquals((String)((String)config.getAnonymousTaskSuffixSupplier().get()), (String)"1");
    }
}

