/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSsh;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="RunScriptOnNodeAsInitScriptUsingSshTest")
public class RunScriptOnNodeAsInitScriptUsingSshTest {
    EventBus eventBus = new EventBus();

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWithoutInitThrowsIllegalStateException() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("notalot").build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSsh testMe = new RunScriptOnNodeAsInitScriptUsingSsh(Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        testMe.call();
    }

    public void testDefault() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("notalot").build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("sudo /tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSsh testMe = new RunScriptOnNodeAsInitScriptUsingSsh(Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        testMe.call();
        EasyMock.verify((Object[])new Object[]{sshClient});
    }

    public void testWithSudoPassword() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("notalot").authenticateSudo(true).build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("echo 'notalot'|sudo -S /tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSsh testMe = new RunScriptOnNodeAsInitScriptUsingSsh(Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        testMe.call();
        EasyMock.verify((Object[])new Object[]{sshClient});
    }

    public void testNotRoot() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("notalot").authenticateSudo(true).build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSsh testMe = new RunScriptOnNodeAsInitScriptUsingSsh(Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions().runAsRoot(false));
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        testMe.call();
        EasyMock.verify((Object[])new Object[]{sshClient});
    }
}

