/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.config.GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNullTest")
public class GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNullTest {
    public void testWhenCredentialsNotPresentReturnsNull() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        Object expected = null;
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.login-user")).andReturn(null);
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.authenticate-sudo")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsNotPresentAndProviderPropertyHasUser() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        Credentials expected = new Credentials("ubuntu", null);
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn((Object)"ubuntu");
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)credstore.put("image", expected)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsNotPresentAndJcloudsPropertyHasUser() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        Credentials expected = new Credentials("ubuntu", null);
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.login-user")).andReturn((Object)"ubuntu");
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)credstore.put("image", expected)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsAlreadyPresentReturnsSame() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        Credentials expected = new Credentials("root", null);
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)true);
        EasyMock.expect(credstore.get("image")).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsNotPresentAndProviderPropertyHasUserAndPassword() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        Credentials expected = new Credentials("ubuntu", "password");
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn((Object)"ubuntu:password");
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)credstore.put("image", expected)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsNotPresentAndJcloudsPropertyHasUserAndPassword() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        Credentials expected = new Credentials("ubuntu", "password");
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.login-user")).andReturn((Object)"ubuntu:password");
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)credstore.put("image", expected)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsNotPresentAndJcloudsPropertyHasUserAndPasswordAndSudo() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        LoginCredentials expected = LoginCredentials.builder().user("ubuntu").password("password").authenticateSudo(true).build();
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.login-user")).andReturn((Object)"ubuntu:password");
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn(null);
        EasyMock.expect((Object)config.apply("jclouds.image.authenticate-sudo")).andReturn((Object)"true");
        EasyMock.expect((Object)credstore.put("image", expected)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testWhenCredentialsNotPresentAndProviderPropertyHasUserAndPasswordAndSudo() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        LoginCredentials expected = LoginCredentials.builder().user("ubuntu").password("password").authenticateSudo(true).build();
        ValueOfConfigurationKeyOrNull config = (ValueOfConfigurationKeyOrNull)EasyMock.createMock(ValueOfConfigurationKeyOrNull.class);
        EasyMock.expect((Object)credstore.containsKey("image")).andReturn((Object)false);
        EasyMock.expect((Object)config.apply("provider.image.login-user")).andReturn((Object)"ubuntu:password");
        EasyMock.expect((Object)config.apply("provider.image.authenticate-sudo")).andReturn((Object)"true");
        EasyMock.expect((Object)credstore.put("image", expected)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{config});
        EasyMock.replay((Object[])new Object[]{credstore});
        GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull fn = new GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull("provider", config, credstore);
        Assert.assertEquals((Object)fn.get(), (Object)expected);
        EasyMock.verify((Object[])new Object[]{config});
        EasyMock.verify((Object[])new Object[]{credstore});
    }
}

