/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.config.CredentialStoreModule;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"integration,live"})
public abstract class BaseTemplateBuilderLiveTest
extends BaseComputeServiceContextLiveTest {
    public void testCompareSizes() throws Exception {
        Hardware defaultSize = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build().getHardware();
        Hardware smallest = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().smallest().build().getHardware();
        Hardware fastest = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().fastest().build().getHardware();
        Hardware biggest = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().biggest().build().getHardware();
        System.out.printf("smallest %s%n", smallest);
        System.out.printf("fastest %s%n", fastest);
        System.out.printf("biggest %s%n", biggest);
        Assert.assertEquals((Object)defaultSize, (Object)smallest);
        assert (ComputeServiceUtils.getCores((Hardware)smallest) <= ComputeServiceUtils.getCores((Hardware)fastest)) : String.format("%s ! <= %s", smallest, fastest);
        assert (ComputeServiceUtils.getCores((Hardware)biggest) <= ComputeServiceUtils.getCores((Hardware)fastest)) : String.format("%s ! <= %s", biggest, fastest);
        assert (biggest.getRam() >= fastest.getRam()) : String.format("%s ! >= %s", biggest, fastest);
        assert (biggest.getRam() >= smallest.getRam()) : String.format("%s ! >= %s", biggest, smallest);
        assert (ComputeServiceUtils.getCores((Hardware)fastest) >= ComputeServiceUtils.getCores((Hardware)biggest)) : String.format("%s ! >= %s", fastest, biggest);
        assert (ComputeServiceUtils.getCores((Hardware)fastest) >= ComputeServiceUtils.getCores((Hardware)smallest)) : String.format("%s ! >= %s", fastest, smallest);
    }

    public void testFromTemplate() {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((String)((ComputeServiceContext)this.view).getComputeService().templateBuilder().fromTemplate(defaultTemplate).build().toString(), (String)defaultTemplate.toString());
    }

    @DataProvider(name="osSupported")
    public Object[][] osSupported() {
        return this.convertToArray(Sets.filter(this.provideAllOperatingSystems(), (Predicate)Predicates.not(this.defineUnsupportedOperatingSystems())));
    }

    protected Object[][] convertToArray(Set<OsFamilyVersion64Bit> supportedOperatingSystems) {
        Object[][] returnVal = new Object[supportedOperatingSystems.size()][1];
        int i = 0;
        for (OsFamilyVersion64Bit config : supportedOperatingSystems) {
            returnVal[i++][0] = config;
        }
        return returnVal;
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.alwaysFalse();
    }

    @DataProvider(name="osNotSupported")
    public Object[][] osNotSupported() {
        return this.convertToArray(Sets.filter(this.provideAllOperatingSystems(), this.defineUnsupportedOperatingSystems()));
    }

    protected Set<OsFamilyVersion64Bit> provideAllOperatingSystems() {
        Map map = new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class));
        HashSet supportedOperatingSystems = Sets.newHashSet();
        for (Map.Entry osVersions : map.entrySet()) {
            for (String version : Sets.newHashSet(((Map)osVersions.getValue()).values())) {
                supportedOperatingSystems.add(new OsFamilyVersion64Bit((OsFamily)osVersions.getKey(), version, false));
                supportedOperatingSystems.add(new OsFamilyVersion64Bit((OsFamily)osVersions.getKey(), version, true));
            }
        }
        return supportedOperatingSystems;
    }

    @Test(dataProvider="osSupported")
    public void testTemplateBuilderCanFind(OsFamilyVersion64Bit matrix) throws InterruptedException {
        TemplateBuilder builder = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().osFamily(matrix.family).os64Bit(matrix.is64Bit);
        if (!matrix.version.equals("")) {
            builder.osVersionMatches("^" + matrix.version + "$");
        }
        Template template = builder.build();
        if (!matrix.version.equals("")) {
            Assert.assertEquals((String)template.getImage().getOperatingSystem().getVersion(), (String)matrix.version);
        }
        Assert.assertEquals((boolean)template.getImage().getOperatingSystem().is64Bit(), (boolean)matrix.is64Bit);
        Assert.assertEquals((Object)template.getImage().getOperatingSystem().getFamily(), (Object)matrix.family);
    }

    @Test(dataProvider="osNotSupported", expectedExceptions={NoSuchElementException.class})
    public void testTemplateBuilderCannotFind(OsFamilyVersion64Bit matrix) throws InterruptedException {
        TemplateBuilder builder = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().osFamily(matrix.family).os64Bit(matrix.is64Bit);
        if (!matrix.version.equals("")) {
            builder.osVersionMatches("^" + matrix.version + "$");
        }
        builder.build();
    }

    @Test
    public void testTemplateBuilderCanUseImageId() throws Exception {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        ((ComputeServiceContext)this.view).close();
        this.setupContext();
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().imageId(defaultTemplate.getImage().getId()).locationId(defaultTemplate.getLocation().getId()).build();
        Assert.assertEquals((Object)template.getImage(), (Object)defaultTemplate.getImage());
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        assert (defaultTemplate.getImage().getOperatingSystem().getVersion().matches("1[012].[10][04]")) : defaultTemplate.getImage().getOperatingSystem().getVersion();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected abstract Set<String> getIso3166Codes();

    @Test(groups={"integration", "live"})
    public void testGetAssignableLocations() throws Exception {
        this.assertProvider((Location)((ComputeServiceContext)this.view).unwrap());
        for (Location location : ((ComputeServiceContext)this.view).getComputeService().listAssignableLocations()) {
            System.err.printf("location %s%n", location);
            assert (location.getId() != null) : location;
            assert (location != location.getParent()) : location;
            assert (location.getScope() != null) : location;
            switch (location.getScope()) {
                case PROVIDER: {
                    this.assertProvider(location);
                    break;
                }
                case REGION: {
                    this.assertProvider(location.getParent());
                    assert (location.getIso3166Codes().size() == 0 || location.getParent().getIso3166Codes().containsAll(location.getIso3166Codes())) : location + " ||" + location.getParent();
                    break;
                }
                case ZONE: {
                    Location provider = location.getParent().getParent();
                    if (provider == null) {
                        provider = location.getParent();
                    }
                    this.assertProvider(provider);
                    assert (location.getIso3166Codes().size() == 0 || location.getParent().getIso3166Codes().containsAll(location.getIso3166Codes())) : location + " ||" + location.getParent();
                    break;
                }
                case SYSTEM: {
                    Location systemParent = location.getParent();
                    while (systemParent.getParent() != null) {
                        systemParent = systemParent.getParent();
                    }
                    this.assertProvider(systemParent);
                    break;
                }
                case NETWORK: {
                    Location networkParent = location.getParent();
                    while (networkParent.getParent() != null) {
                        networkParent = networkParent.getParent();
                    }
                    this.assertProvider(networkParent);
                    break;
                }
                case HOST: {
                    Location provider2 = location.getParent().getParent().getParent();
                    if (provider2 == null) {
                        provider2 = location.getParent().getParent();
                    }
                    this.assertProvider(provider2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderWithImageIdSpecified() throws IOException {
        Properties overrides;
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        ComputeServiceContext context = null;
        try {
            overrides = this.setupProperties();
            overrides.setProperty("jclouds.image-id", defaultTemplate.getImage().getId());
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Assert.assertEquals((String)context.getComputeService().templateBuilder().build().toString(), (String)defaultTemplate.toString());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = null;
        try {
            overrides = this.setupProperties();
            overrides.setProperty(this.provider + ".image-id", defaultTemplate.getImage().getId());
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Assert.assertEquals((String)context.getComputeService().templateBuilder().build().toString(), (String)defaultTemplate.toString());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    public void testTemplateBuilderWithLoginUserSpecified() throws IOException {
        this.tryOverrideUsingPropertyKey("jclouds");
        this.tryOverrideUsingPropertyKey(this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryOverrideUsingPropertyKey(String propertyKey) {
        CredentialStoreModule credentialStoreModule = new CredentialStoreModule((Map)new CopyInputStreamInputSupplierMap(new ConcurrentHashMap()));
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            String login = this.template != null && this.template.getLoginUser() != null ? this.template.getLoginUser() : "foo:bar";
            overrides.setProperty(propertyKey + ".image.login-user", login);
            boolean auth = this.template != null && this.template.getAuthenticateSudo() != null ? this.template.getAuthenticateSudo() : true;
            overrides.setProperty(propertyKey + ".image.authenticate-sudo", auth + "");
            context = (ComputeServiceContext)this.createView(overrides, (Iterable)ImmutableSet.of((Object)credentialStoreModule));
            Iterable userPass = Splitter.on((char)':').split((CharSequence)login);
            String user = (String)Iterables.get((Iterable)userPass, (int)0);
            String pass = Iterables.size((Iterable)userPass) > 1 ? (String)Iterables.get((Iterable)userPass, (int)1) : null;
            Assert.assertEquals((Object)context.getComputeService().templateBuilder().build().getImage().getDefaultCredentials(), (Object)LoginCredentials.builder().user(user).password(pass).authenticateSudo(auth).build());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    void assertProvider(Location provider) {
        Assert.assertEquals((Object)provider.getScope(), (Object)LocationScope.PROVIDER);
        Assert.assertEquals((Object)provider.getParent(), null);
        Assert.assertEquals((Set)provider.getIso3166Codes(), this.getIso3166Codes());
    }
}

