/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.predicates.AtomicNodeRunning;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="AtomicNodePredicatesTest")
public class AtomicNodePredicatesTest {
    private NodeMetadata node;
    private GetNodeMetadataStrategy computeService;

    @Test
    public void testNoUpdatesAtomicReferenceOnPass() {
        NodeMetadata running = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.RUNNING).build();
        GetNodeMetadataStrategy computeService = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        EasyMock.replay((Object[])new Object[]{computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(computeService);
        AtomicReference reference = Atomics.newReference((Object)running);
        Assert.assertTrue((boolean)nodeRunning.apply(reference));
        Assert.assertEquals(reference.get(), (Object)running);
        EasyMock.verify((Object[])new Object[]{computeService});
    }

    @Test
    public void testRefreshUpdatesAtomicReferenceOnRecheckPending() {
        NodeMetadata pending = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.PENDING).build();
        GetNodeMetadataStrategy computeService = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        EasyMock.expect((Object)computeService.getNode("myid")).andReturn((Object)pending);
        EasyMock.replay((Object[])new Object[]{computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(computeService);
        AtomicReference reference = Atomics.newReference((Object)pending);
        Assert.assertFalse((boolean)nodeRunning.apply(reference));
        Assert.assertEquals(reference.get(), (Object)pending);
        EasyMock.verify((Object[])new Object[]{computeService});
    }

    @Test
    public void testRefreshUpdatesAtomicReferenceOnRecheckPendingAcceptsNewCredentials() {
        LoginCredentials creds = LoginCredentials.builder().user("user").password("password").build();
        NodeMetadata newNode = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.UNRECOGNIZED).credentials(creds).build();
        LoginCredentials creds2 = LoginCredentials.builder().user("user").password("password2").build();
        NodeMetadata pending = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.PENDING).credentials(creds2).build();
        GetNodeMetadataStrategy computeService = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        EasyMock.expect((Object)computeService.getNode("myid")).andReturn((Object)pending);
        EasyMock.replay((Object[])new Object[]{computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(computeService);
        AtomicReference reference = Atomics.newReference((Object)newNode);
        Assert.assertFalse((boolean)nodeRunning.apply(reference));
        Assert.assertEquals(reference.get(), (Object)pending);
        EasyMock.verify((Object[])new Object[]{computeService});
    }

    @Test
    public void testRefreshUpdatesAtomicReferenceOnRecheckRunning() {
        NodeMetadata running = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.RUNNING).build();
        NodeMetadata pending = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.PENDING).build();
        GetNodeMetadataStrategy computeService = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        EasyMock.expect((Object)computeService.getNode("myid")).andReturn((Object)running);
        EasyMock.replay((Object[])new Object[]{computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(computeService);
        AtomicReference reference = Atomics.newReference((Object)pending);
        Assert.assertTrue((boolean)nodeRunning.apply(reference));
        Assert.assertEquals(reference.get(), (Object)running);
        EasyMock.verify((Object[])new Object[]{computeService});
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        this.computeService = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        EasyMock.expect((Object)this.node.getId()).andReturn((Object)"myid").anyTimes();
        EasyMock.expect((Object)this.computeService.getNode("myid")).andReturn((Object)this.node).anyTimes();
        EasyMock.expect((Object)this.node.getLocation()).andReturn(null).anyTimes();
    }

    @Test
    public void testNodeRunningReturnsTrueWhenRunning() {
        EasyMock.expect((Object)this.node.getStatus()).andReturn((Object)NodeMetadata.Status.RUNNING).atLeastOnce();
        EasyMock.expect((Object)this.node.getBackendStatus()).andReturn(null).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.node});
        EasyMock.replay((Object[])new Object[]{this.computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(this.computeService);
        AtomicReference reference = Atomics.newReference((Object)this.node);
        Assert.assertTrue((boolean)nodeRunning.apply(reference));
        Assert.assertEquals(reference.get(), (Object)this.node);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNodeRunningFailsOnTerminated() {
        EasyMock.expect((Object)this.node.getStatus()).andReturn((Object)NodeMetadata.Status.TERMINATED).atLeastOnce();
        EasyMock.expect((Object)this.node.getBackendStatus()).andReturn(null).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.node});
        EasyMock.replay((Object[])new Object[]{this.computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(this.computeService);
        AtomicReference reference = Atomics.newReference((Object)this.node);
        nodeRunning.apply(reference);
        Assert.assertEquals(reference.get(), (Object)this.node);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNodeRunningFailsOnError() {
        EasyMock.expect((Object)this.node.getStatus()).andReturn((Object)NodeMetadata.Status.ERROR).atLeastOnce();
        EasyMock.expect((Object)this.node.getBackendStatus()).andReturn(null).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.node});
        EasyMock.replay((Object[])new Object[]{this.computeService});
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(this.computeService);
        AtomicReference reference = Atomics.newReference((Object)this.node);
        nodeRunning.apply(reference);
        Assert.assertEquals(reference.get(), (Object)this.node);
    }
}

